/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupStatus;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupType;
import com.amazonaws.services.elasticmapreduce.model.MarketType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceGroup
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private String market;
    private String instanceGroupType;
    private String bidPrice;
    private String instanceType;
    private Integer requestedInstanceCount;
    private Integer runningInstanceCount;
    private InstanceGroupStatus status;
    private SdkInternalList<Configuration> configurations;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public InstanceGroup withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InstanceGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getMarket() {
        return this.market;
    }

    public InstanceGroup withMarket(String market) {
        this.setMarket(market);
        return this;
    }

    public void setMarket(MarketType market) {
        this.market = market.toString();
    }

    public InstanceGroup withMarket(MarketType market) {
        this.setMarket(market);
        return this;
    }

    public void setInstanceGroupType(String instanceGroupType) {
        this.instanceGroupType = instanceGroupType;
    }

    public String getInstanceGroupType() {
        return this.instanceGroupType;
    }

    public InstanceGroup withInstanceGroupType(String instanceGroupType) {
        this.setInstanceGroupType(instanceGroupType);
        return this;
    }

    public void setInstanceGroupType(InstanceGroupType instanceGroupType) {
        this.instanceGroupType = instanceGroupType.toString();
    }

    public InstanceGroup withInstanceGroupType(InstanceGroupType instanceGroupType) {
        this.setInstanceGroupType(instanceGroupType);
        return this;
    }

    public void setBidPrice(String bidPrice) {
        this.bidPrice = bidPrice;
    }

    public String getBidPrice() {
        return this.bidPrice;
    }

    public InstanceGroup withBidPrice(String bidPrice) {
        this.setBidPrice(bidPrice);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceGroup withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setRequestedInstanceCount(Integer requestedInstanceCount) {
        this.requestedInstanceCount = requestedInstanceCount;
    }

    public Integer getRequestedInstanceCount() {
        return this.requestedInstanceCount;
    }

    public InstanceGroup withRequestedInstanceCount(Integer requestedInstanceCount) {
        this.setRequestedInstanceCount(requestedInstanceCount);
        return this;
    }

    public void setRunningInstanceCount(Integer runningInstanceCount) {
        this.runningInstanceCount = runningInstanceCount;
    }

    public Integer getRunningInstanceCount() {
        return this.runningInstanceCount;
    }

    public InstanceGroup withRunningInstanceCount(Integer runningInstanceCount) {
        this.setRunningInstanceCount(runningInstanceCount);
        return this;
    }

    public void setStatus(InstanceGroupStatus status) {
        this.status = status;
    }

    public InstanceGroupStatus getStatus() {
        return this.status;
    }

    public InstanceGroup withStatus(InstanceGroupStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList<Configuration>(configurations);
    }

    public InstanceGroup withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new SdkInternalList<Configuration>(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public InstanceGroup withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getMarket() != null) {
            sb.append("Market: " + this.getMarket() + ",");
        }
        if (this.getInstanceGroupType() != null) {
            sb.append("InstanceGroupType: " + this.getInstanceGroupType() + ",");
        }
        if (this.getBidPrice() != null) {
            sb.append("BidPrice: " + this.getBidPrice() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getRequestedInstanceCount() != null) {
            sb.append("RequestedInstanceCount: " + this.getRequestedInstanceCount() + ",");
        }
        if (this.getRunningInstanceCount() != null) {
            sb.append("RunningInstanceCount: " + this.getRunningInstanceCount() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: " + this.getConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroup)) {
            return false;
        }
        InstanceGroup other = (InstanceGroup)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMarket() == null ^ this.getMarket() == null) {
            return false;
        }
        if (other.getMarket() != null && !other.getMarket().equals(this.getMarket())) {
            return false;
        }
        if (other.getInstanceGroupType() == null ^ this.getInstanceGroupType() == null) {
            return false;
        }
        if (other.getInstanceGroupType() != null && !other.getInstanceGroupType().equals(this.getInstanceGroupType())) {
            return false;
        }
        if (other.getBidPrice() == null ^ this.getBidPrice() == null) {
            return false;
        }
        if (other.getBidPrice() != null && !other.getBidPrice().equals(this.getBidPrice())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getRequestedInstanceCount() == null ^ this.getRequestedInstanceCount() == null) {
            return false;
        }
        if (other.getRequestedInstanceCount() != null && !other.getRequestedInstanceCount().equals(this.getRequestedInstanceCount())) {
            return false;
        }
        if (other.getRunningInstanceCount() == null ^ this.getRunningInstanceCount() == null) {
            return false;
        }
        if (other.getRunningInstanceCount() != null && !other.getRunningInstanceCount().equals(this.getRunningInstanceCount())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        return other.getConfigurations() == null || other.getConfigurations().equals(this.getConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMarket() == null ? 0 : this.getMarket().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroupType() == null ? 0 : this.getInstanceGroupType().hashCode());
        hashCode = 31 * hashCode + (this.getBidPrice() == null ? 0 : this.getBidPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedInstanceCount() == null ? 0 : this.getRequestedInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getRunningInstanceCount() == null ? 0 : this.getRunningInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        return hashCode;
    }

    public InstanceGroup clone() {
        try {
            return (InstanceGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

