/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateCaseRequestMarshaller
implements Marshaller<Request<CreateCaseRequest>, CreateCaseRequest> {
    @Override
    public Request<CreateCaseRequest> marshall(CreateCaseRequest createCaseRequest) {
        if (createCaseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCaseRequest> request = new DefaultRequest<CreateCaseRequest>(createCaseRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.CreateCase");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ccEmailAddressesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createCaseRequest.getSubject() != null) {
                jsonWriter.key("subject").value(createCaseRequest.getSubject());
            }
            if (createCaseRequest.getServiceCode() != null) {
                jsonWriter.key("serviceCode").value(createCaseRequest.getServiceCode());
            }
            if (createCaseRequest.getSeverityCode() != null) {
                jsonWriter.key("severityCode").value(createCaseRequest.getSeverityCode());
            }
            if (createCaseRequest.getCategoryCode() != null) {
                jsonWriter.key("categoryCode").value(createCaseRequest.getCategoryCode());
            }
            if (createCaseRequest.getCommunicationBody() != null) {
                jsonWriter.key("communicationBody").value(createCaseRequest.getCommunicationBody());
            }
            if (!(ccEmailAddressesList = (SdkInternalList)createCaseRequest.getCcEmailAddresses()).isEmpty() || !ccEmailAddressesList.isAutoConstruct()) {
                jsonWriter.key("ccEmailAddresses");
                jsonWriter.array();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonWriter.value(ccEmailAddressesListValue);
                }
                jsonWriter.endArray();
            }
            if (createCaseRequest.getLanguage() != null) {
                jsonWriter.key("language").value(createCaseRequest.getLanguage());
            }
            if (createCaseRequest.getIssueType() != null) {
                jsonWriter.key("issueType").value(createCaseRequest.getIssueType());
            }
            if (createCaseRequest.getAttachmentSetId() != null) {
                jsonWriter.key("attachmentSetId").value(createCaseRequest.getAttachmentSetId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

