/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.Stack;
import com.amazonaws.services.opsworks.model.transform.ChefConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class StackJsonMarshaller {
    private static StackJsonMarshaller instance;

    public void marshall(Stack stack, JSONWriter jsonWriter) {
        if (stack == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap attributesMap;
            jsonWriter.object();
            if (stack.getStackId() != null) {
                jsonWriter.key("StackId").value(stack.getStackId());
            }
            if (stack.getName() != null) {
                jsonWriter.key("Name").value(stack.getName());
            }
            if (stack.getArn() != null) {
                jsonWriter.key("Arn").value(stack.getArn());
            }
            if (stack.getRegion() != null) {
                jsonWriter.key("Region").value(stack.getRegion());
            }
            if (stack.getVpcId() != null) {
                jsonWriter.key("VpcId").value(stack.getVpcId());
            }
            if (!(attributesMap = (SdkInternalMap)stack.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (stack.getServiceRoleArn() != null) {
                jsonWriter.key("ServiceRoleArn").value(stack.getServiceRoleArn());
            }
            if (stack.getDefaultInstanceProfileArn() != null) {
                jsonWriter.key("DefaultInstanceProfileArn").value(stack.getDefaultInstanceProfileArn());
            }
            if (stack.getDefaultOs() != null) {
                jsonWriter.key("DefaultOs").value(stack.getDefaultOs());
            }
            if (stack.getHostnameTheme() != null) {
                jsonWriter.key("HostnameTheme").value(stack.getHostnameTheme());
            }
            if (stack.getDefaultAvailabilityZone() != null) {
                jsonWriter.key("DefaultAvailabilityZone").value(stack.getDefaultAvailabilityZone());
            }
            if (stack.getDefaultSubnetId() != null) {
                jsonWriter.key("DefaultSubnetId").value(stack.getDefaultSubnetId());
            }
            if (stack.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value(stack.getCustomJson());
            }
            if (stack.getConfigurationManager() != null) {
                jsonWriter.key("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(stack.getConfigurationManager(), jsonWriter);
            }
            if (stack.getChefConfiguration() != null) {
                jsonWriter.key("ChefConfiguration");
                ChefConfigurationJsonMarshaller.getInstance().marshall(stack.getChefConfiguration(), jsonWriter);
            }
            if (stack.getUseCustomCookbooks() != null) {
                jsonWriter.key("UseCustomCookbooks").value(stack.getUseCustomCookbooks());
            }
            if (stack.getUseOpsworksSecurityGroups() != null) {
                jsonWriter.key("UseOpsworksSecurityGroups").value(stack.getUseOpsworksSecurityGroups());
            }
            if (stack.getCustomCookbooksSource() != null) {
                jsonWriter.key("CustomCookbooksSource");
                SourceJsonMarshaller.getInstance().marshall(stack.getCustomCookbooksSource(), jsonWriter);
            }
            if (stack.getDefaultSshKeyName() != null) {
                jsonWriter.key("DefaultSshKeyName").value(stack.getDefaultSshKeyName());
            }
            if (stack.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(stack.getCreatedAt());
            }
            if (stack.getDefaultRootDeviceType() != null) {
                jsonWriter.key("DefaultRootDeviceType").value(stack.getDefaultRootDeviceType());
            }
            if (stack.getAgentVersion() != null) {
                jsonWriter.key("AgentVersion").value(stack.getAgentVersion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StackJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StackJsonMarshaller();
        }
        return instance;
    }
}

