/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.StepStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepTimelineJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StepStatusJsonMarshaller {
    private static StepStatusJsonMarshaller instance;

    public void marshall(StepStatus stepStatus, JSONWriter jsonWriter) {
        if (stepStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (stepStatus.getState() != null) {
                jsonWriter.key("State").value(stepStatus.getState());
            }
            if (stepStatus.getStateChangeReason() != null) {
                jsonWriter.key("StateChangeReason");
                StepStateChangeReasonJsonMarshaller.getInstance().marshall(stepStatus.getStateChangeReason(), jsonWriter);
            }
            if (stepStatus.getTimeline() != null) {
                jsonWriter.key("Timeline");
                StepTimelineJsonMarshaller.getInstance().marshall(stepStatus.getTimeline(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepStatusJsonMarshaller();
        }
        return instance;
    }
}

