/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListStepsRequestMarshaller
implements Marshaller<Request<ListStepsRequest>, ListStepsRequest> {
    @Override
    public Request<ListStepsRequest> marshall(ListStepsRequest listStepsRequest) {
        if (listStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStepsRequest> request = new DefaultRequest<ListStepsRequest>(listStepsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListSteps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList stepIdsList;
            SdkInternalList stepStatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listStepsRequest.getClusterId() != null) {
                jsonWriter.key("ClusterId").value(listStepsRequest.getClusterId());
            }
            if (!(stepStatesList = (SdkInternalList)listStepsRequest.getStepStates()).isEmpty() || !stepStatesList.isAutoConstruct()) {
                jsonWriter.key("StepStates");
                jsonWriter.array();
                for (String stepStatesListValue : stepStatesList) {
                    if (stepStatesListValue == null) continue;
                    jsonWriter.value(stepStatesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(stepIdsList = (SdkInternalList)listStepsRequest.getStepIds()).isEmpty() || !stepIdsList.isAutoConstruct()) {
                jsonWriter.key("StepIds");
                jsonWriter.array();
                for (String stepIdsListValue : stepIdsList) {
                    if (stepIdsListValue == null) continue;
                    jsonWriter.value(stepIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (listStepsRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listStepsRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

