/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BatchGetItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, KeysAndAttributes> requestItems;
    private String returnConsumedCapacity;

    public BatchGetItemRequest() {
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> requestItems) {
        this.setRequestItems(requestItems);
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        this.setRequestItems(requestItems);
        this.setReturnConsumedCapacity(returnConsumedCapacity);
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> requestItems, ReturnConsumedCapacity returnConsumedCapacity) {
        this.setRequestItems(requestItems);
        this.setReturnConsumedCapacity(returnConsumedCapacity.toString());
    }

    public Map<String, KeysAndAttributes> getRequestItems() {
        return this.requestItems;
    }

    public void setRequestItems(Map<String, KeysAndAttributes> requestItems) {
        this.requestItems = requestItems;
    }

    public BatchGetItemRequest withRequestItems(Map<String, KeysAndAttributes> requestItems) {
        this.setRequestItems(requestItems);
        return this;
    }

    public BatchGetItemRequest addRequestItemsEntry(String key, KeysAndAttributes value) {
        if (null == this.requestItems) {
            this.requestItems = new HashMap<String, KeysAndAttributes>();
        }
        if (this.requestItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestItems.put(key, value);
        return this;
    }

    public BatchGetItemRequest clearRequestItemsEntries() {
        this.requestItems = null;
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public BatchGetItemRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public BatchGetItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequestItems() != null) {
            sb.append("RequestItems: " + this.getRequestItems() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest other = (BatchGetItemRequest)obj;
        if (other.getRequestItems() == null ^ this.getRequestItems() == null) {
            return false;
        }
        if (other.getRequestItems() != null && !other.getRequestItems().equals(this.getRequestItems())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return other.getReturnConsumedCapacity() == null || other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequestItems() == null ? 0 : this.getRequestItems().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public BatchGetItemRequest clone() {
        return (BatchGetItemRequest)super.clone();
    }
}

