/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeComplianceByConfigRuleRequestMarshaller
implements Marshaller<Request<DescribeComplianceByConfigRuleRequest>, DescribeComplianceByConfigRuleRequest> {
    @Override
    public Request<DescribeComplianceByConfigRuleRequest> marshall(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        if (describeComplianceByConfigRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeComplianceByConfigRuleRequest> request = new DefaultRequest<DescribeComplianceByConfigRuleRequest>(describeComplianceByConfigRuleRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeComplianceByConfigRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList complianceTypesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList configRuleNamesList = (SdkInternalList)describeComplianceByConfigRuleRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonWriter.key("ConfigRuleNames");
                jsonWriter.array();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonWriter.value(configRuleNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(complianceTypesList = (SdkInternalList)describeComplianceByConfigRuleRequest.getComplianceTypes()).isEmpty() || !complianceTypesList.isAutoConstruct()) {
                jsonWriter.key("ComplianceTypes");
                jsonWriter.array();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonWriter.value(complianceTypesListValue);
                }
                jsonWriter.endArray();
            }
            if (describeComplianceByConfigRuleRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeComplianceByConfigRuleRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

