/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.MethodSetting;
import com.amazonaws.services.apigateway.model.Stage;
import com.amazonaws.services.apigateway.model.transform.MethodSettingJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class StageJsonMarshaller {
    private static StageJsonMarshaller instance;

    public void marshall(Stage stage, JSONWriter jsonWriter) {
        if (stage == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, MethodSetting> methodSettingsMap;
            jsonWriter.object();
            if (stage.getDeploymentId() != null) {
                jsonWriter.key("deploymentId").value(stage.getDeploymentId());
            }
            if (stage.getClientCertificateId() != null) {
                jsonWriter.key("clientCertificateId").value(stage.getClientCertificateId());
            }
            if (stage.getStageName() != null) {
                jsonWriter.key("stageName").value(stage.getStageName());
            }
            if (stage.getDescription() != null) {
                jsonWriter.key("description").value(stage.getDescription());
            }
            if (stage.getCacheClusterEnabled() != null) {
                jsonWriter.key("cacheClusterEnabled").value(stage.getCacheClusterEnabled());
            }
            if (stage.getCacheClusterSize() != null) {
                jsonWriter.key("cacheClusterSize").value(stage.getCacheClusterSize());
            }
            if (stage.getCacheClusterStatus() != null) {
                jsonWriter.key("cacheClusterStatus").value(stage.getCacheClusterStatus());
            }
            if ((methodSettingsMap = stage.getMethodSettings()) != null) {
                jsonWriter.key("methodSettings");
                jsonWriter.object();
                for (Map.Entry<String, MethodSetting> methodSettingsMapValue : methodSettingsMap.entrySet()) {
                    if (methodSettingsMapValue.getValue() == null) continue;
                    jsonWriter.key(methodSettingsMapValue.getKey());
                    MethodSettingJsonMarshaller.getInstance().marshall(methodSettingsMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (stage.getCreatedDate() != null) {
                jsonWriter.key("createdDate").value(stage.getCreatedDate());
            }
            if (stage.getLastUpdatedDate() != null) {
                jsonWriter.key("lastUpdatedDate").value(stage.getLastUpdatedDate());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StageJsonMarshaller();
        }
        return instance;
    }
}

