/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.ActivatedRule;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ActivatedRuleJsonMarshaller {
    private static ActivatedRuleJsonMarshaller instance;

    public void marshall(ActivatedRule activatedRule, JSONWriter jsonWriter) {
        if (activatedRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (activatedRule.getPriority() != null) {
                jsonWriter.key("Priority").value(activatedRule.getPriority());
            }
            if (activatedRule.getRuleId() != null) {
                jsonWriter.key("RuleId").value(activatedRule.getRuleId());
            }
            if (activatedRule.getAction() != null) {
                jsonWriter.key("Action");
                WafActionJsonMarshaller.getInstance().marshall(activatedRule.getAction(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActivatedRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActivatedRuleJsonMarshaller();
        }
        return instance;
    }
}

