/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeElasticIpsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeElasticIpsRequestMarshaller
implements Marshaller<Request<DescribeElasticIpsRequest>, DescribeElasticIpsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeElasticIpsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeElasticIpsRequest> marshall(DescribeElasticIpsRequest describeElasticIpsRequest) {
        if (describeElasticIpsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeElasticIpsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeElasticIps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ipsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeElasticIpsRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeElasticIpsRequest.getInstanceId());
            }
            if (describeElasticIpsRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeElasticIpsRequest.getStackId());
            }
            if (!(ipsList = (SdkInternalList)describeElasticIpsRequest.getIps()).isEmpty() || !ipsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Ips");
                jsonGenerator.writeStartArray();
                for (String ipsListValue : ipsList) {
                    if (ipsListValue == null) continue;
                    jsonGenerator.writeValue(ipsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

