/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworks.model.LayerType;
import com.amazonaws.services.opsworks.model.LifecycleEventConfiguration;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LayerMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Layer
implements Serializable,
Cloneable,
StructuredPojo {
    private String stackId;
    private String layerId;
    private String type;
    private String name;
    private String shortname;
    private SdkInternalMap<String, String> attributes;
    private String customInstanceProfileArn;
    private String customJson;
    private SdkInternalList<String> customSecurityGroupIds;
    private SdkInternalList<String> defaultSecurityGroupNames;
    private SdkInternalList<String> packages;
    private SdkInternalList<VolumeConfiguration> volumeConfigurations;
    private Boolean enableAutoHealing;
    private Boolean autoAssignElasticIps;
    private Boolean autoAssignPublicIps;
    private Recipes defaultRecipes;
    private Recipes customRecipes;
    private String createdAt;
    private Boolean installUpdatesOnBoot;
    private Boolean useEbsOptimizedInstances;
    private LifecycleEventConfiguration lifecycleEventConfiguration;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public Layer withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public Layer withLayerId(String layerId) {
        this.setLayerId(layerId);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Layer withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(LayerType type) {
        this.type = type.toString();
    }

    public Layer withType(LayerType type) {
        this.setType(type);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Layer withName(String name) {
        this.setName(name);
        return this;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getShortname() {
        return this.shortname;
    }

    public Layer withShortname(String shortname) {
        this.setShortname(shortname);
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new SdkInternalMap(attributes);
    }

    public Layer withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Layer addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new SdkInternalMap();
        }
        if (this.attributes.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put((Object)key, (Object)value);
        return this;
    }

    public Layer clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setCustomInstanceProfileArn(String customInstanceProfileArn) {
        this.customInstanceProfileArn = customInstanceProfileArn;
    }

    public String getCustomInstanceProfileArn() {
        return this.customInstanceProfileArn;
    }

    public Layer withCustomInstanceProfileArn(String customInstanceProfileArn) {
        this.setCustomInstanceProfileArn(customInstanceProfileArn);
        return this;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public Layer withCustomJson(String customJson) {
        this.setCustomJson(customJson);
        return this;
    }

    public List<String> getCustomSecurityGroupIds() {
        if (this.customSecurityGroupIds == null) {
            this.customSecurityGroupIds = new SdkInternalList();
        }
        return this.customSecurityGroupIds;
    }

    public void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
        if (customSecurityGroupIds == null) {
            this.customSecurityGroupIds = null;
            return;
        }
        this.customSecurityGroupIds = new SdkInternalList(customSecurityGroupIds);
    }

    public Layer withCustomSecurityGroupIds(String ... customSecurityGroupIds) {
        if (this.customSecurityGroupIds == null) {
            this.setCustomSecurityGroupIds((Collection<String>)new SdkInternalList(customSecurityGroupIds.length));
        }
        for (String ele : customSecurityGroupIds) {
            this.customSecurityGroupIds.add((Object)ele);
        }
        return this;
    }

    public Layer withCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
        this.setCustomSecurityGroupIds(customSecurityGroupIds);
        return this;
    }

    public List<String> getDefaultSecurityGroupNames() {
        if (this.defaultSecurityGroupNames == null) {
            this.defaultSecurityGroupNames = new SdkInternalList();
        }
        return this.defaultSecurityGroupNames;
    }

    public void setDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
        if (defaultSecurityGroupNames == null) {
            this.defaultSecurityGroupNames = null;
            return;
        }
        this.defaultSecurityGroupNames = new SdkInternalList(defaultSecurityGroupNames);
    }

    public Layer withDefaultSecurityGroupNames(String ... defaultSecurityGroupNames) {
        if (this.defaultSecurityGroupNames == null) {
            this.setDefaultSecurityGroupNames((Collection<String>)new SdkInternalList(defaultSecurityGroupNames.length));
        }
        for (String ele : defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames.add((Object)ele);
        }
        return this;
    }

    public Layer withDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
        this.setDefaultSecurityGroupNames(defaultSecurityGroupNames);
        return this;
    }

    public List<String> getPackages() {
        if (this.packages == null) {
            this.packages = new SdkInternalList();
        }
        return this.packages;
    }

    public void setPackages(Collection<String> packages) {
        if (packages == null) {
            this.packages = null;
            return;
        }
        this.packages = new SdkInternalList(packages);
    }

    public Layer withPackages(String ... packages) {
        if (this.packages == null) {
            this.setPackages((Collection<String>)new SdkInternalList(packages.length));
        }
        for (String ele : packages) {
            this.packages.add((Object)ele);
        }
        return this;
    }

    public Layer withPackages(Collection<String> packages) {
        this.setPackages(packages);
        return this;
    }

    public List<VolumeConfiguration> getVolumeConfigurations() {
        if (this.volumeConfigurations == null) {
            this.volumeConfigurations = new SdkInternalList();
        }
        return this.volumeConfigurations;
    }

    public void setVolumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
        if (volumeConfigurations == null) {
            this.volumeConfigurations = null;
            return;
        }
        this.volumeConfigurations = new SdkInternalList(volumeConfigurations);
    }

    public Layer withVolumeConfigurations(VolumeConfiguration ... volumeConfigurations) {
        if (this.volumeConfigurations == null) {
            this.setVolumeConfigurations((Collection<VolumeConfiguration>)new SdkInternalList(volumeConfigurations.length));
        }
        for (VolumeConfiguration ele : volumeConfigurations) {
            this.volumeConfigurations.add((Object)ele);
        }
        return this;
    }

    public Layer withVolumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
        this.setVolumeConfigurations(volumeConfigurations);
        return this;
    }

    public void setEnableAutoHealing(Boolean enableAutoHealing) {
        this.enableAutoHealing = enableAutoHealing;
    }

    public Boolean getEnableAutoHealing() {
        return this.enableAutoHealing;
    }

    public Layer withEnableAutoHealing(Boolean enableAutoHealing) {
        this.setEnableAutoHealing(enableAutoHealing);
        return this;
    }

    public Boolean isEnableAutoHealing() {
        return this.enableAutoHealing;
    }

    public void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
        this.autoAssignElasticIps = autoAssignElasticIps;
    }

    public Boolean getAutoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public Layer withAutoAssignElasticIps(Boolean autoAssignElasticIps) {
        this.setAutoAssignElasticIps(autoAssignElasticIps);
        return this;
    }

    public Boolean isAutoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
        this.autoAssignPublicIps = autoAssignPublicIps;
    }

    public Boolean getAutoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public Layer withAutoAssignPublicIps(Boolean autoAssignPublicIps) {
        this.setAutoAssignPublicIps(autoAssignPublicIps);
        return this;
    }

    public Boolean isAutoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public void setDefaultRecipes(Recipes defaultRecipes) {
        this.defaultRecipes = defaultRecipes;
    }

    public Recipes getDefaultRecipes() {
        return this.defaultRecipes;
    }

    public Layer withDefaultRecipes(Recipes defaultRecipes) {
        this.setDefaultRecipes(defaultRecipes);
        return this;
    }

    public void setCustomRecipes(Recipes customRecipes) {
        this.customRecipes = customRecipes;
    }

    public Recipes getCustomRecipes() {
        return this.customRecipes;
    }

    public Layer withCustomRecipes(Recipes customRecipes) {
        this.setCustomRecipes(customRecipes);
        return this;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Layer withCreatedAt(String createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Layer withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.setInstallUpdatesOnBoot(installUpdatesOnBoot);
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
        this.useEbsOptimizedInstances = useEbsOptimizedInstances;
    }

    public Boolean getUseEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public Layer withUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
        this.setUseEbsOptimizedInstances(useEbsOptimizedInstances);
        return this;
    }

    public Boolean isUseEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public void setLifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
        this.lifecycleEventConfiguration = lifecycleEventConfiguration;
    }

    public LifecycleEventConfiguration getLifecycleEventConfiguration() {
        return this.lifecycleEventConfiguration;
    }

    public Layer withLifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
        this.setLifecycleEventConfiguration(lifecycleEventConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getLayerId() != null) {
            sb.append("LayerId: ").append(this.getLayerId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getShortname() != null) {
            sb.append("Shortname: ").append(this.getShortname()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getCustomInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: ").append(this.getCustomInstanceProfileArn()).append(",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: ").append(this.getCustomJson()).append(",");
        }
        if (this.getCustomSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: ").append(this.getCustomSecurityGroupIds()).append(",");
        }
        if (this.getDefaultSecurityGroupNames() != null) {
            sb.append("DefaultSecurityGroupNames: ").append(this.getDefaultSecurityGroupNames()).append(",");
        }
        if (this.getPackages() != null) {
            sb.append("Packages: ").append(this.getPackages()).append(",");
        }
        if (this.getVolumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(this.getVolumeConfigurations()).append(",");
        }
        if (this.getEnableAutoHealing() != null) {
            sb.append("EnableAutoHealing: ").append(this.getEnableAutoHealing()).append(",");
        }
        if (this.getAutoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: ").append(this.getAutoAssignElasticIps()).append(",");
        }
        if (this.getAutoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: ").append(this.getAutoAssignPublicIps()).append(",");
        }
        if (this.getDefaultRecipes() != null) {
            sb.append("DefaultRecipes: ").append(this.getDefaultRecipes()).append(",");
        }
        if (this.getCustomRecipes() != null) {
            sb.append("CustomRecipes: ").append(this.getCustomRecipes()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.getInstallUpdatesOnBoot()).append(",");
        }
        if (this.getUseEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: ").append(this.getUseEbsOptimizedInstances()).append(",");
        }
        if (this.getLifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: ").append(this.getLifecycleEventConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getLayerId() == null ^ this.getLayerId() == null) {
            return false;
        }
        if (other.getLayerId() != null && !other.getLayerId().equals(this.getLayerId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getShortname() == null ^ this.getShortname() == null) {
            return false;
        }
        if (other.getShortname() != null && !other.getShortname().equals(this.getShortname())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getCustomInstanceProfileArn() == null ^ this.getCustomInstanceProfileArn() == null) {
            return false;
        }
        if (other.getCustomInstanceProfileArn() != null && !other.getCustomInstanceProfileArn().equals(this.getCustomInstanceProfileArn())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        if (other.getCustomJson() != null && !other.getCustomJson().equals(this.getCustomJson())) {
            return false;
        }
        if (other.getCustomSecurityGroupIds() == null ^ this.getCustomSecurityGroupIds() == null) {
            return false;
        }
        if (other.getCustomSecurityGroupIds() != null && !other.getCustomSecurityGroupIds().equals(this.getCustomSecurityGroupIds())) {
            return false;
        }
        if (other.getDefaultSecurityGroupNames() == null ^ this.getDefaultSecurityGroupNames() == null) {
            return false;
        }
        if (other.getDefaultSecurityGroupNames() != null && !other.getDefaultSecurityGroupNames().equals(this.getDefaultSecurityGroupNames())) {
            return false;
        }
        if (other.getPackages() == null ^ this.getPackages() == null) {
            return false;
        }
        if (other.getPackages() != null && !other.getPackages().equals(this.getPackages())) {
            return false;
        }
        if (other.getVolumeConfigurations() == null ^ this.getVolumeConfigurations() == null) {
            return false;
        }
        if (other.getVolumeConfigurations() != null && !other.getVolumeConfigurations().equals(this.getVolumeConfigurations())) {
            return false;
        }
        if (other.getEnableAutoHealing() == null ^ this.getEnableAutoHealing() == null) {
            return false;
        }
        if (other.getEnableAutoHealing() != null && !other.getEnableAutoHealing().equals(this.getEnableAutoHealing())) {
            return false;
        }
        if (other.getAutoAssignElasticIps() == null ^ this.getAutoAssignElasticIps() == null) {
            return false;
        }
        if (other.getAutoAssignElasticIps() != null && !other.getAutoAssignElasticIps().equals(this.getAutoAssignElasticIps())) {
            return false;
        }
        if (other.getAutoAssignPublicIps() == null ^ this.getAutoAssignPublicIps() == null) {
            return false;
        }
        if (other.getAutoAssignPublicIps() != null && !other.getAutoAssignPublicIps().equals(this.getAutoAssignPublicIps())) {
            return false;
        }
        if (other.getDefaultRecipes() == null ^ this.getDefaultRecipes() == null) {
            return false;
        }
        if (other.getDefaultRecipes() != null && !other.getDefaultRecipes().equals(this.getDefaultRecipes())) {
            return false;
        }
        if (other.getCustomRecipes() == null ^ this.getCustomRecipes() == null) {
            return false;
        }
        if (other.getCustomRecipes() != null && !other.getCustomRecipes().equals(this.getCustomRecipes())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() == null ^ this.getInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() != null && !other.getInstallUpdatesOnBoot().equals(this.getInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.getUseEbsOptimizedInstances() == null ^ this.getUseEbsOptimizedInstances() == null) {
            return false;
        }
        if (other.getUseEbsOptimizedInstances() != null && !other.getUseEbsOptimizedInstances().equals(this.getUseEbsOptimizedInstances())) {
            return false;
        }
        if (other.getLifecycleEventConfiguration() == null ^ this.getLifecycleEventConfiguration() == null) {
            return false;
        }
        return other.getLifecycleEventConfiguration() == null || other.getLifecycleEventConfiguration().equals(this.getLifecycleEventConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerId() == null ? 0 : this.getLayerId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getShortname() == null ? 0 : this.getShortname().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCustomInstanceProfileArn() == null ? 0 : this.getCustomInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        hashCode = 31 * hashCode + (this.getCustomSecurityGroupIds() == null ? 0 : this.getCustomSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSecurityGroupNames() == null ? 0 : this.getDefaultSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getPackages() == null ? 0 : this.getPackages().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeConfigurations() == null ? 0 : this.getVolumeConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEnableAutoHealing() == null ? 0 : this.getEnableAutoHealing().hashCode());
        hashCode = 31 * hashCode + (this.getAutoAssignElasticIps() == null ? 0 : this.getAutoAssignElasticIps().hashCode());
        hashCode = 31 * hashCode + (this.getAutoAssignPublicIps() == null ? 0 : this.getAutoAssignPublicIps().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultRecipes() == null ? 0 : this.getDefaultRecipes().hashCode());
        hashCode = 31 * hashCode + (this.getCustomRecipes() == null ? 0 : this.getCustomRecipes().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getInstallUpdatesOnBoot() == null ? 0 : this.getInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.getUseEbsOptimizedInstances() == null ? 0 : this.getUseEbsOptimizedInstances().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleEventConfiguration() == null ? 0 : this.getLifecycleEventConfiguration().hashCode());
        return hashCode;
    }

    public Layer clone() {
        try {
            return (Layer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

