/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DetachElasticLoadBalancerRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DetachElasticLoadBalancerRequestMarshaller
implements Marshaller<Request<DetachElasticLoadBalancerRequest>, DetachElasticLoadBalancerRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DetachElasticLoadBalancerRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DetachElasticLoadBalancerRequest> marshall(DetachElasticLoadBalancerRequest detachElasticLoadBalancerRequest) {
        if (detachElasticLoadBalancerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachElasticLoadBalancerRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DetachElasticLoadBalancer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (detachElasticLoadBalancerRequest.getElasticLoadBalancerName() != null) {
                jsonGenerator.writeFieldName("ElasticLoadBalancerName").writeValue(detachElasticLoadBalancerRequest.getElasticLoadBalancerName());
            }
            if (detachElasticLoadBalancerRequest.getLayerId() != null) {
                jsonGenerator.writeFieldName("LayerId").writeValue(detachElasticLoadBalancerRequest.getLayerId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

