/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearchserverless;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.opensearchserverless.AWSOpenSearchServerlessAsync;
import com.amazonaws.services.opensearchserverless.AWSOpenSearchServerlessAsyncClientBuilder;
import com.amazonaws.services.opensearchserverless.AWSOpenSearchServerlessClient;
import com.amazonaws.services.opensearchserverless.model.BatchGetCollectionRequest;
import com.amazonaws.services.opensearchserverless.model.BatchGetCollectionResult;
import com.amazonaws.services.opensearchserverless.model.BatchGetVpcEndpointRequest;
import com.amazonaws.services.opensearchserverless.model.BatchGetVpcEndpointResult;
import com.amazonaws.services.opensearchserverless.model.CreateAccessPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.CreateAccessPolicyResult;
import com.amazonaws.services.opensearchserverless.model.CreateCollectionRequest;
import com.amazonaws.services.opensearchserverless.model.CreateCollectionResult;
import com.amazonaws.services.opensearchserverless.model.CreateSecurityConfigRequest;
import com.amazonaws.services.opensearchserverless.model.CreateSecurityConfigResult;
import com.amazonaws.services.opensearchserverless.model.CreateSecurityPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.CreateSecurityPolicyResult;
import com.amazonaws.services.opensearchserverless.model.CreateVpcEndpointRequest;
import com.amazonaws.services.opensearchserverless.model.CreateVpcEndpointResult;
import com.amazonaws.services.opensearchserverless.model.DeleteAccessPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.DeleteAccessPolicyResult;
import com.amazonaws.services.opensearchserverless.model.DeleteCollectionRequest;
import com.amazonaws.services.opensearchserverless.model.DeleteCollectionResult;
import com.amazonaws.services.opensearchserverless.model.DeleteSecurityConfigRequest;
import com.amazonaws.services.opensearchserverless.model.DeleteSecurityConfigResult;
import com.amazonaws.services.opensearchserverless.model.DeleteSecurityPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.DeleteSecurityPolicyResult;
import com.amazonaws.services.opensearchserverless.model.DeleteVpcEndpointRequest;
import com.amazonaws.services.opensearchserverless.model.DeleteVpcEndpointResult;
import com.amazonaws.services.opensearchserverless.model.GetAccessPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.GetAccessPolicyResult;
import com.amazonaws.services.opensearchserverless.model.GetAccountSettingsRequest;
import com.amazonaws.services.opensearchserverless.model.GetAccountSettingsResult;
import com.amazonaws.services.opensearchserverless.model.GetPoliciesStatsRequest;
import com.amazonaws.services.opensearchserverless.model.GetPoliciesStatsResult;
import com.amazonaws.services.opensearchserverless.model.GetSecurityConfigRequest;
import com.amazonaws.services.opensearchserverless.model.GetSecurityConfigResult;
import com.amazonaws.services.opensearchserverless.model.GetSecurityPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.GetSecurityPolicyResult;
import com.amazonaws.services.opensearchserverless.model.ListAccessPoliciesRequest;
import com.amazonaws.services.opensearchserverless.model.ListAccessPoliciesResult;
import com.amazonaws.services.opensearchserverless.model.ListCollectionsRequest;
import com.amazonaws.services.opensearchserverless.model.ListCollectionsResult;
import com.amazonaws.services.opensearchserverless.model.ListSecurityConfigsRequest;
import com.amazonaws.services.opensearchserverless.model.ListSecurityConfigsResult;
import com.amazonaws.services.opensearchserverless.model.ListSecurityPoliciesRequest;
import com.amazonaws.services.opensearchserverless.model.ListSecurityPoliciesResult;
import com.amazonaws.services.opensearchserverless.model.ListTagsForResourceRequest;
import com.amazonaws.services.opensearchserverless.model.ListTagsForResourceResult;
import com.amazonaws.services.opensearchserverless.model.ListVpcEndpointsRequest;
import com.amazonaws.services.opensearchserverless.model.ListVpcEndpointsResult;
import com.amazonaws.services.opensearchserverless.model.TagResourceRequest;
import com.amazonaws.services.opensearchserverless.model.TagResourceResult;
import com.amazonaws.services.opensearchserverless.model.UntagResourceRequest;
import com.amazonaws.services.opensearchserverless.model.UntagResourceResult;
import com.amazonaws.services.opensearchserverless.model.UpdateAccessPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateAccessPolicyResult;
import com.amazonaws.services.opensearchserverless.model.UpdateAccountSettingsRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateAccountSettingsResult;
import com.amazonaws.services.opensearchserverless.model.UpdateCollectionRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateCollectionResult;
import com.amazonaws.services.opensearchserverless.model.UpdateSecurityConfigRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateSecurityConfigResult;
import com.amazonaws.services.opensearchserverless.model.UpdateSecurityPolicyRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateSecurityPolicyResult;
import com.amazonaws.services.opensearchserverless.model.UpdateVpcEndpointRequest;
import com.amazonaws.services.opensearchserverless.model.UpdateVpcEndpointResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOpenSearchServerlessAsyncClient
extends AWSOpenSearchServerlessClient
implements AWSOpenSearchServerlessAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSOpenSearchServerlessAsyncClientBuilder asyncBuilder() {
        return AWSOpenSearchServerlessAsyncClientBuilder.standard();
    }

    AWSOpenSearchServerlessAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSOpenSearchServerlessAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetCollectionResult> batchGetCollectionAsync(BatchGetCollectionRequest request) {
        return this.batchGetCollectionAsync(request, null);
    }

    @Override
    public Future<BatchGetCollectionResult> batchGetCollectionAsync(BatchGetCollectionRequest request, final AsyncHandler<BatchGetCollectionRequest, BatchGetCollectionResult> asyncHandler) {
        final BatchGetCollectionRequest finalRequest = (BatchGetCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetCollectionResult>(){

            @Override
            public BatchGetCollectionResult call() throws Exception {
                BatchGetCollectionResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeBatchGetCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetVpcEndpointResult> batchGetVpcEndpointAsync(BatchGetVpcEndpointRequest request) {
        return this.batchGetVpcEndpointAsync(request, null);
    }

    @Override
    public Future<BatchGetVpcEndpointResult> batchGetVpcEndpointAsync(BatchGetVpcEndpointRequest request, final AsyncHandler<BatchGetVpcEndpointRequest, BatchGetVpcEndpointResult> asyncHandler) {
        final BatchGetVpcEndpointRequest finalRequest = (BatchGetVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetVpcEndpointResult>(){

            @Override
            public BatchGetVpcEndpointResult call() throws Exception {
                BatchGetVpcEndpointResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeBatchGetVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request) {
        return this.createAccessPolicyAsync(request, null);
    }

    @Override
    public Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request, final AsyncHandler<CreateAccessPolicyRequest, CreateAccessPolicyResult> asyncHandler) {
        final CreateAccessPolicyRequest finalRequest = (CreateAccessPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccessPolicyResult>(){

            @Override
            public CreateAccessPolicyResult call() throws Exception {
                CreateAccessPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeCreateAccessPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request) {
        return this.createCollectionAsync(request, null);
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request, final AsyncHandler<CreateCollectionRequest, CreateCollectionResult> asyncHandler) {
        final CreateCollectionRequest finalRequest = (CreateCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCollectionResult>(){

            @Override
            public CreateCollectionResult call() throws Exception {
                CreateCollectionResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeCreateCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSecurityConfigResult> createSecurityConfigAsync(CreateSecurityConfigRequest request) {
        return this.createSecurityConfigAsync(request, null);
    }

    @Override
    public Future<CreateSecurityConfigResult> createSecurityConfigAsync(CreateSecurityConfigRequest request, final AsyncHandler<CreateSecurityConfigRequest, CreateSecurityConfigResult> asyncHandler) {
        final CreateSecurityConfigRequest finalRequest = (CreateSecurityConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSecurityConfigResult>(){

            @Override
            public CreateSecurityConfigResult call() throws Exception {
                CreateSecurityConfigResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeCreateSecurityConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSecurityPolicyResult> createSecurityPolicyAsync(CreateSecurityPolicyRequest request) {
        return this.createSecurityPolicyAsync(request, null);
    }

    @Override
    public Future<CreateSecurityPolicyResult> createSecurityPolicyAsync(CreateSecurityPolicyRequest request, final AsyncHandler<CreateSecurityPolicyRequest, CreateSecurityPolicyResult> asyncHandler) {
        final CreateSecurityPolicyRequest finalRequest = (CreateSecurityPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSecurityPolicyResult>(){

            @Override
            public CreateSecurityPolicyResult call() throws Exception {
                CreateSecurityPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeCreateSecurityPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request) {
        return this.createVpcEndpointAsync(request, null);
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request, final AsyncHandler<CreateVpcEndpointRequest, CreateVpcEndpointResult> asyncHandler) {
        final CreateVpcEndpointRequest finalRequest = (CreateVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVpcEndpointResult>(){

            @Override
            public CreateVpcEndpointResult call() throws Exception {
                CreateVpcEndpointResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeCreateVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request) {
        return this.deleteAccessPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request, final AsyncHandler<DeleteAccessPolicyRequest, DeleteAccessPolicyResult> asyncHandler) {
        final DeleteAccessPolicyRequest finalRequest = (DeleteAccessPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccessPolicyResult>(){

            @Override
            public DeleteAccessPolicyResult call() throws Exception {
                DeleteAccessPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeDeleteAccessPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request) {
        return this.deleteCollectionAsync(request, null);
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request, final AsyncHandler<DeleteCollectionRequest, DeleteCollectionResult> asyncHandler) {
        final DeleteCollectionRequest finalRequest = (DeleteCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCollectionResult>(){

            @Override
            public DeleteCollectionResult call() throws Exception {
                DeleteCollectionResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeDeleteCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSecurityConfigResult> deleteSecurityConfigAsync(DeleteSecurityConfigRequest request) {
        return this.deleteSecurityConfigAsync(request, null);
    }

    @Override
    public Future<DeleteSecurityConfigResult> deleteSecurityConfigAsync(DeleteSecurityConfigRequest request, final AsyncHandler<DeleteSecurityConfigRequest, DeleteSecurityConfigResult> asyncHandler) {
        final DeleteSecurityConfigRequest finalRequest = (DeleteSecurityConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSecurityConfigResult>(){

            @Override
            public DeleteSecurityConfigResult call() throws Exception {
                DeleteSecurityConfigResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeDeleteSecurityConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSecurityPolicyResult> deleteSecurityPolicyAsync(DeleteSecurityPolicyRequest request) {
        return this.deleteSecurityPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteSecurityPolicyResult> deleteSecurityPolicyAsync(DeleteSecurityPolicyRequest request, final AsyncHandler<DeleteSecurityPolicyRequest, DeleteSecurityPolicyResult> asyncHandler) {
        final DeleteSecurityPolicyRequest finalRequest = (DeleteSecurityPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSecurityPolicyResult>(){

            @Override
            public DeleteSecurityPolicyResult call() throws Exception {
                DeleteSecurityPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeDeleteSecurityPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request) {
        return this.deleteVpcEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request, final AsyncHandler<DeleteVpcEndpointRequest, DeleteVpcEndpointResult> asyncHandler) {
        final DeleteVpcEndpointRequest finalRequest = (DeleteVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVpcEndpointResult>(){

            @Override
            public DeleteVpcEndpointResult call() throws Exception {
                DeleteVpcEndpointResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeDeleteVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessPolicyResult> getAccessPolicyAsync(GetAccessPolicyRequest request) {
        return this.getAccessPolicyAsync(request, null);
    }

    @Override
    public Future<GetAccessPolicyResult> getAccessPolicyAsync(GetAccessPolicyRequest request, final AsyncHandler<GetAccessPolicyRequest, GetAccessPolicyResult> asyncHandler) {
        final GetAccessPolicyRequest finalRequest = (GetAccessPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessPolicyResult>(){

            @Override
            public GetAccessPolicyResult call() throws Exception {
                GetAccessPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeGetAccessPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request) {
        return this.getAccountSettingsAsync(request, null);
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request, final AsyncHandler<GetAccountSettingsRequest, GetAccountSettingsResult> asyncHandler) {
        final GetAccountSettingsRequest finalRequest = (GetAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountSettingsResult>(){

            @Override
            public GetAccountSettingsResult call() throws Exception {
                GetAccountSettingsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeGetAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPoliciesStatsResult> getPoliciesStatsAsync(GetPoliciesStatsRequest request) {
        return this.getPoliciesStatsAsync(request, null);
    }

    @Override
    public Future<GetPoliciesStatsResult> getPoliciesStatsAsync(GetPoliciesStatsRequest request, final AsyncHandler<GetPoliciesStatsRequest, GetPoliciesStatsResult> asyncHandler) {
        final GetPoliciesStatsRequest finalRequest = (GetPoliciesStatsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPoliciesStatsResult>(){

            @Override
            public GetPoliciesStatsResult call() throws Exception {
                GetPoliciesStatsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeGetPoliciesStats(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSecurityConfigResult> getSecurityConfigAsync(GetSecurityConfigRequest request) {
        return this.getSecurityConfigAsync(request, null);
    }

    @Override
    public Future<GetSecurityConfigResult> getSecurityConfigAsync(GetSecurityConfigRequest request, final AsyncHandler<GetSecurityConfigRequest, GetSecurityConfigResult> asyncHandler) {
        final GetSecurityConfigRequest finalRequest = (GetSecurityConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSecurityConfigResult>(){

            @Override
            public GetSecurityConfigResult call() throws Exception {
                GetSecurityConfigResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeGetSecurityConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSecurityPolicyResult> getSecurityPolicyAsync(GetSecurityPolicyRequest request) {
        return this.getSecurityPolicyAsync(request, null);
    }

    @Override
    public Future<GetSecurityPolicyResult> getSecurityPolicyAsync(GetSecurityPolicyRequest request, final AsyncHandler<GetSecurityPolicyRequest, GetSecurityPolicyResult> asyncHandler) {
        final GetSecurityPolicyRequest finalRequest = (GetSecurityPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSecurityPolicyResult>(){

            @Override
            public GetSecurityPolicyResult call() throws Exception {
                GetSecurityPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeGetSecurityPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request) {
        return this.listAccessPoliciesAsync(request, null);
    }

    @Override
    public Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request, final AsyncHandler<ListAccessPoliciesRequest, ListAccessPoliciesResult> asyncHandler) {
        final ListAccessPoliciesRequest finalRequest = (ListAccessPoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccessPoliciesResult>(){

            @Override
            public ListAccessPoliciesResult call() throws Exception {
                ListAccessPoliciesResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListAccessPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request) {
        return this.listCollectionsAsync(request, null);
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request, final AsyncHandler<ListCollectionsRequest, ListCollectionsResult> asyncHandler) {
        final ListCollectionsRequest finalRequest = (ListCollectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCollectionsResult>(){

            @Override
            public ListCollectionsResult call() throws Exception {
                ListCollectionsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListCollections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSecurityConfigsResult> listSecurityConfigsAsync(ListSecurityConfigsRequest request) {
        return this.listSecurityConfigsAsync(request, null);
    }

    @Override
    public Future<ListSecurityConfigsResult> listSecurityConfigsAsync(ListSecurityConfigsRequest request, final AsyncHandler<ListSecurityConfigsRequest, ListSecurityConfigsResult> asyncHandler) {
        final ListSecurityConfigsRequest finalRequest = (ListSecurityConfigsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSecurityConfigsResult>(){

            @Override
            public ListSecurityConfigsResult call() throws Exception {
                ListSecurityConfigsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListSecurityConfigs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSecurityPoliciesResult> listSecurityPoliciesAsync(ListSecurityPoliciesRequest request) {
        return this.listSecurityPoliciesAsync(request, null);
    }

    @Override
    public Future<ListSecurityPoliciesResult> listSecurityPoliciesAsync(ListSecurityPoliciesRequest request, final AsyncHandler<ListSecurityPoliciesRequest, ListSecurityPoliciesResult> asyncHandler) {
        final ListSecurityPoliciesRequest finalRequest = (ListSecurityPoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSecurityPoliciesResult>(){

            @Override
            public ListSecurityPoliciesResult call() throws Exception {
                ListSecurityPoliciesResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListSecurityPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request) {
        return this.listVpcEndpointsAsync(request, null);
    }

    @Override
    public Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request, final AsyncHandler<ListVpcEndpointsRequest, ListVpcEndpointsResult> asyncHandler) {
        final ListVpcEndpointsRequest finalRequest = (ListVpcEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVpcEndpointsResult>(){

            @Override
            public ListVpcEndpointsResult call() throws Exception {
                ListVpcEndpointsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeListVpcEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request) {
        return this.updateAccessPolicyAsync(request, null);
    }

    @Override
    public Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request, final AsyncHandler<UpdateAccessPolicyRequest, UpdateAccessPolicyResult> asyncHandler) {
        final UpdateAccessPolicyRequest finalRequest = (UpdateAccessPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccessPolicyResult>(){

            @Override
            public UpdateAccessPolicyResult call() throws Exception {
                UpdateAccessPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateAccessPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request) {
        return this.updateAccountSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request, final AsyncHandler<UpdateAccountSettingsRequest, UpdateAccountSettingsResult> asyncHandler) {
        final UpdateAccountSettingsRequest finalRequest = (UpdateAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountSettingsResult>(){

            @Override
            public UpdateAccountSettingsResult call() throws Exception {
                UpdateAccountSettingsResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCollectionResult> updateCollectionAsync(UpdateCollectionRequest request) {
        return this.updateCollectionAsync(request, null);
    }

    @Override
    public Future<UpdateCollectionResult> updateCollectionAsync(UpdateCollectionRequest request, final AsyncHandler<UpdateCollectionRequest, UpdateCollectionResult> asyncHandler) {
        final UpdateCollectionRequest finalRequest = (UpdateCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCollectionResult>(){

            @Override
            public UpdateCollectionResult call() throws Exception {
                UpdateCollectionResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSecurityConfigResult> updateSecurityConfigAsync(UpdateSecurityConfigRequest request) {
        return this.updateSecurityConfigAsync(request, null);
    }

    @Override
    public Future<UpdateSecurityConfigResult> updateSecurityConfigAsync(UpdateSecurityConfigRequest request, final AsyncHandler<UpdateSecurityConfigRequest, UpdateSecurityConfigResult> asyncHandler) {
        final UpdateSecurityConfigRequest finalRequest = (UpdateSecurityConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSecurityConfigResult>(){

            @Override
            public UpdateSecurityConfigResult call() throws Exception {
                UpdateSecurityConfigResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateSecurityConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSecurityPolicyResult> updateSecurityPolicyAsync(UpdateSecurityPolicyRequest request) {
        return this.updateSecurityPolicyAsync(request, null);
    }

    @Override
    public Future<UpdateSecurityPolicyResult> updateSecurityPolicyAsync(UpdateSecurityPolicyRequest request, final AsyncHandler<UpdateSecurityPolicyRequest, UpdateSecurityPolicyResult> asyncHandler) {
        final UpdateSecurityPolicyRequest finalRequest = (UpdateSecurityPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSecurityPolicyResult>(){

            @Override
            public UpdateSecurityPolicyResult call() throws Exception {
                UpdateSecurityPolicyResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateSecurityPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request) {
        return this.updateVpcEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request, final AsyncHandler<UpdateVpcEndpointRequest, UpdateVpcEndpointResult> asyncHandler) {
        final UpdateVpcEndpointRequest finalRequest = (UpdateVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVpcEndpointResult>(){

            @Override
            public UpdateVpcEndpointResult call() throws Exception {
                UpdateVpcEndpointResult result = null;
                try {
                    result = AWSOpenSearchServerlessAsyncClient.this.executeUpdateVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

