/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;
import com.amazonaws.services.omics.model.ReferenceItem;
import com.amazonaws.services.omics.model.SseConfig;
import com.amazonaws.services.omics.model.StoreFormat;
import com.amazonaws.services.omics.model.StoreOptions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateAnnotationStoreRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
SignerTypeAware {
    private ReferenceItem reference;
    private String name;
    private String description;
    private Map<String, String> tags;
    private String versionName;
    private SseConfig sseConfig;
    private String storeFormat;
    private StoreOptions storeOptions;

    public void setReference(ReferenceItem reference) {
        this.reference = reference;
    }

    public ReferenceItem getReference() {
        return this.reference;
    }

    public CreateAnnotationStoreRequest withReference(ReferenceItem reference) {
        this.setReference(reference);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAnnotationStoreRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAnnotationStoreRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAnnotationStoreRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAnnotationStoreRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAnnotationStoreRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public CreateAnnotationStoreRequest withVersionName(String versionName) {
        this.setVersionName(versionName);
        return this;
    }

    public void setSseConfig(SseConfig sseConfig) {
        this.sseConfig = sseConfig;
    }

    public SseConfig getSseConfig() {
        return this.sseConfig;
    }

    public CreateAnnotationStoreRequest withSseConfig(SseConfig sseConfig) {
        this.setSseConfig(sseConfig);
        return this;
    }

    public void setStoreFormat(String storeFormat) {
        this.storeFormat = storeFormat;
    }

    public String getStoreFormat() {
        return this.storeFormat;
    }

    public CreateAnnotationStoreRequest withStoreFormat(String storeFormat) {
        this.setStoreFormat(storeFormat);
        return this;
    }

    public CreateAnnotationStoreRequest withStoreFormat(StoreFormat storeFormat) {
        this.storeFormat = storeFormat.toString();
        return this;
    }

    public void setStoreOptions(StoreOptions storeOptions) {
        this.storeOptions = storeOptions;
    }

    public StoreOptions getStoreOptions() {
        return this.storeOptions;
    }

    public CreateAnnotationStoreRequest withStoreOptions(StoreOptions storeOptions) {
        this.setStoreOptions(storeOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReference() != null) {
            sb.append("Reference: ").append(this.getReference()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVersionName() != null) {
            sb.append("VersionName: ").append(this.getVersionName()).append(",");
        }
        if (this.getSseConfig() != null) {
            sb.append("SseConfig: ").append(this.getSseConfig()).append(",");
        }
        if (this.getStoreFormat() != null) {
            sb.append("StoreFormat: ").append(this.getStoreFormat()).append(",");
        }
        if (this.getStoreOptions() != null) {
            sb.append("StoreOptions: ").append(this.getStoreOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreRequest)) {
            return false;
        }
        CreateAnnotationStoreRequest other = (CreateAnnotationStoreRequest)obj;
        if (other.getReference() == null ^ this.getReference() == null) {
            return false;
        }
        if (other.getReference() != null && !other.getReference().equals(this.getReference())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVersionName() == null ^ this.getVersionName() == null) {
            return false;
        }
        if (other.getVersionName() != null && !other.getVersionName().equals(this.getVersionName())) {
            return false;
        }
        if (other.getSseConfig() == null ^ this.getSseConfig() == null) {
            return false;
        }
        if (other.getSseConfig() != null && !other.getSseConfig().equals(this.getSseConfig())) {
            return false;
        }
        if (other.getStoreFormat() == null ^ this.getStoreFormat() == null) {
            return false;
        }
        if (other.getStoreFormat() != null && !other.getStoreFormat().equals(this.getStoreFormat())) {
            return false;
        }
        if (other.getStoreOptions() == null ^ this.getStoreOptions() == null) {
            return false;
        }
        return other.getStoreOptions() == null || other.getStoreOptions().equals(this.getStoreOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReference() == null ? 0 : this.getReference().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVersionName() == null ? 0 : this.getVersionName().hashCode());
        hashCode = 31 * hashCode + (this.getSseConfig() == null ? 0 : this.getSseConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoreFormat() == null ? 0 : this.getStoreFormat().hashCode());
        hashCode = 31 * hashCode + (this.getStoreOptions() == null ? 0 : this.getStoreOptions().hashCode());
        return hashCode;
    }

    public CreateAnnotationStoreRequest clone() {
        return (CreateAnnotationStoreRequest)super.clone();
    }

    public String getSignerType() {
        return "AWS4SignerType";
    }
}

