/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.omics.model.FileInformation;

@SdkInternalApi
public class FileInformationMarshaller {
    private static final MarshallingInfo<Long> CONTENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentLength").build();
    private static final MarshallingInfo<Long> PARTSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partSize").build();
    private static final MarshallingInfo<Integer> TOTALPARTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalParts").build();
    private static final FileInformationMarshaller instance = new FileInformationMarshaller();

    public static FileInformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileInformation fileInformation, ProtocolMarshaller protocolMarshaller) {
        if (fileInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileInformation.getContentLength(), CONTENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)fileInformation.getPartSize(), PARTSIZE_BINDING);
            protocolMarshaller.marshall((Object)fileInformation.getTotalParts(), TOTALPARTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

