/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.nimblestudio.model.StreamConfiguration;
import java.util.List;

@SdkInternalApi
public class StreamConfigurationMarshaller {
    private static final MarshallingInfo<String> CLIPBOARDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clipboardMode").build();
    private static final MarshallingInfo<List> EC2INSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2InstanceTypes").build();
    private static final MarshallingInfo<Integer> MAXSESSIONLENGTHINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxSessionLengthInMinutes").build();
    private static final MarshallingInfo<List> STREAMINGIMAGEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamingImageIds").build();
    private static final StreamConfigurationMarshaller instance = new StreamConfigurationMarshaller();

    public static StreamConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamConfiguration streamConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (streamConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamConfiguration.getClipboardMode(), CLIPBOARDMODE_BINDING);
            protocolMarshaller.marshall(streamConfiguration.getEc2InstanceTypes(), EC2INSTANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)streamConfiguration.getMaxSessionLengthInMinutes(), MAXSESSIONLENGTHINMINUTES_BINDING);
            protocolMarshaller.marshall(streamConfiguration.getStreamingImageIds(), STREAMINGIMAGEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

