/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.StreamingClipboardMode;
import com.amazonaws.services.nimblestudio.model.StreamingInstanceType;
import com.amazonaws.services.nimblestudio.model.transform.StreamConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String clipboardMode;
    private List<String> ec2InstanceTypes;
    private Integer maxSessionLengthInMinutes;
    private Integer maxStoppedSessionLengthInMinutes;
    private List<String> streamingImageIds;

    public void setClipboardMode(String clipboardMode) {
        this.clipboardMode = clipboardMode;
    }

    public String getClipboardMode() {
        return this.clipboardMode;
    }

    public StreamConfiguration withClipboardMode(String clipboardMode) {
        this.setClipboardMode(clipboardMode);
        return this;
    }

    public StreamConfiguration withClipboardMode(StreamingClipboardMode clipboardMode) {
        this.clipboardMode = clipboardMode.toString();
        return this;
    }

    public List<String> getEc2InstanceTypes() {
        return this.ec2InstanceTypes;
    }

    public void setEc2InstanceTypes(Collection<String> ec2InstanceTypes) {
        if (ec2InstanceTypes == null) {
            this.ec2InstanceTypes = null;
            return;
        }
        this.ec2InstanceTypes = new ArrayList<String>(ec2InstanceTypes);
    }

    public StreamConfiguration withEc2InstanceTypes(String ... ec2InstanceTypes) {
        if (this.ec2InstanceTypes == null) {
            this.setEc2InstanceTypes(new ArrayList<String>(ec2InstanceTypes.length));
        }
        for (String ele : ec2InstanceTypes) {
            this.ec2InstanceTypes.add(ele);
        }
        return this;
    }

    public StreamConfiguration withEc2InstanceTypes(Collection<String> ec2InstanceTypes) {
        this.setEc2InstanceTypes(ec2InstanceTypes);
        return this;
    }

    public StreamConfiguration withEc2InstanceTypes(StreamingInstanceType ... ec2InstanceTypes) {
        ArrayList<String> ec2InstanceTypesCopy = new ArrayList<String>(ec2InstanceTypes.length);
        for (StreamingInstanceType value : ec2InstanceTypes) {
            ec2InstanceTypesCopy.add(value.toString());
        }
        if (this.getEc2InstanceTypes() == null) {
            this.setEc2InstanceTypes(ec2InstanceTypesCopy);
        } else {
            this.getEc2InstanceTypes().addAll(ec2InstanceTypesCopy);
        }
        return this;
    }

    public void setMaxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
        this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
    }

    public Integer getMaxSessionLengthInMinutes() {
        return this.maxSessionLengthInMinutes;
    }

    public StreamConfiguration withMaxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
        this.setMaxSessionLengthInMinutes(maxSessionLengthInMinutes);
        return this;
    }

    public void setMaxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
        this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
    }

    public Integer getMaxStoppedSessionLengthInMinutes() {
        return this.maxStoppedSessionLengthInMinutes;
    }

    public StreamConfiguration withMaxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
        this.setMaxStoppedSessionLengthInMinutes(maxStoppedSessionLengthInMinutes);
        return this;
    }

    public List<String> getStreamingImageIds() {
        return this.streamingImageIds;
    }

    public void setStreamingImageIds(Collection<String> streamingImageIds) {
        if (streamingImageIds == null) {
            this.streamingImageIds = null;
            return;
        }
        this.streamingImageIds = new ArrayList<String>(streamingImageIds);
    }

    public StreamConfiguration withStreamingImageIds(String ... streamingImageIds) {
        if (this.streamingImageIds == null) {
            this.setStreamingImageIds(new ArrayList<String>(streamingImageIds.length));
        }
        for (String ele : streamingImageIds) {
            this.streamingImageIds.add(ele);
        }
        return this;
    }

    public StreamConfiguration withStreamingImageIds(Collection<String> streamingImageIds) {
        this.setStreamingImageIds(streamingImageIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClipboardMode() != null) {
            sb.append("ClipboardMode: ").append(this.getClipboardMode()).append(",");
        }
        if (this.getEc2InstanceTypes() != null) {
            sb.append("Ec2InstanceTypes: ").append(this.getEc2InstanceTypes()).append(",");
        }
        if (this.getMaxSessionLengthInMinutes() != null) {
            sb.append("MaxSessionLengthInMinutes: ").append(this.getMaxSessionLengthInMinutes()).append(",");
        }
        if (this.getMaxStoppedSessionLengthInMinutes() != null) {
            sb.append("MaxStoppedSessionLengthInMinutes: ").append(this.getMaxStoppedSessionLengthInMinutes()).append(",");
        }
        if (this.getStreamingImageIds() != null) {
            sb.append("StreamingImageIds: ").append(this.getStreamingImageIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfiguration)) {
            return false;
        }
        StreamConfiguration other = (StreamConfiguration)obj;
        if (other.getClipboardMode() == null ^ this.getClipboardMode() == null) {
            return false;
        }
        if (other.getClipboardMode() != null && !other.getClipboardMode().equals(this.getClipboardMode())) {
            return false;
        }
        if (other.getEc2InstanceTypes() == null ^ this.getEc2InstanceTypes() == null) {
            return false;
        }
        if (other.getEc2InstanceTypes() != null && !other.getEc2InstanceTypes().equals(this.getEc2InstanceTypes())) {
            return false;
        }
        if (other.getMaxSessionLengthInMinutes() == null ^ this.getMaxSessionLengthInMinutes() == null) {
            return false;
        }
        if (other.getMaxSessionLengthInMinutes() != null && !other.getMaxSessionLengthInMinutes().equals(this.getMaxSessionLengthInMinutes())) {
            return false;
        }
        if (other.getMaxStoppedSessionLengthInMinutes() == null ^ this.getMaxStoppedSessionLengthInMinutes() == null) {
            return false;
        }
        if (other.getMaxStoppedSessionLengthInMinutes() != null && !other.getMaxStoppedSessionLengthInMinutes().equals(this.getMaxStoppedSessionLengthInMinutes())) {
            return false;
        }
        if (other.getStreamingImageIds() == null ^ this.getStreamingImageIds() == null) {
            return false;
        }
        return other.getStreamingImageIds() == null || other.getStreamingImageIds().equals(this.getStreamingImageIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClipboardMode() == null ? 0 : this.getClipboardMode().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceTypes() == null ? 0 : this.getEc2InstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSessionLengthInMinutes() == null ? 0 : this.getMaxSessionLengthInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxStoppedSessionLengthInMinutes() == null ? 0 : this.getMaxStoppedSessionLengthInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingImageIds() == null ? 0 : this.getStreamingImageIds().hashCode());
        return hashCode;
    }

    public StreamConfiguration clone() {
        try {
            return (StreamConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

