/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.CoreNetworkEdge;
import com.amazonaws.services.networkmanager.model.CoreNetworkSegment;
import com.amazonaws.services.networkmanager.model.CoreNetworkState;
import com.amazonaws.services.networkmanager.model.Tag;
import com.amazonaws.services.networkmanager.model.transform.CoreNetworkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CoreNetwork
implements Serializable,
Cloneable,
StructuredPojo {
    private String globalNetworkId;
    private String coreNetworkId;
    private String coreNetworkArn;
    private String description;
    private Date createdAt;
    private String state;
    private List<CoreNetworkSegment> segments;
    private List<CoreNetworkEdge> edges;
    private List<Tag> tags;

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public CoreNetwork withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public void setCoreNetworkId(String coreNetworkId) {
        this.coreNetworkId = coreNetworkId;
    }

    public String getCoreNetworkId() {
        return this.coreNetworkId;
    }

    public CoreNetwork withCoreNetworkId(String coreNetworkId) {
        this.setCoreNetworkId(coreNetworkId);
        return this;
    }

    public void setCoreNetworkArn(String coreNetworkArn) {
        this.coreNetworkArn = coreNetworkArn;
    }

    public String getCoreNetworkArn() {
        return this.coreNetworkArn;
    }

    public CoreNetwork withCoreNetworkArn(String coreNetworkArn) {
        this.setCoreNetworkArn(coreNetworkArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CoreNetwork withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public CoreNetwork withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public CoreNetwork withState(String state) {
        this.setState(state);
        return this;
    }

    public CoreNetwork withState(CoreNetworkState state) {
        this.state = state.toString();
        return this;
    }

    public List<CoreNetworkSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(Collection<CoreNetworkSegment> segments) {
        if (segments == null) {
            this.segments = null;
            return;
        }
        this.segments = new ArrayList<CoreNetworkSegment>(segments);
    }

    public CoreNetwork withSegments(CoreNetworkSegment ... segments) {
        if (this.segments == null) {
            this.setSegments(new ArrayList<CoreNetworkSegment>(segments.length));
        }
        for (CoreNetworkSegment ele : segments) {
            this.segments.add(ele);
        }
        return this;
    }

    public CoreNetwork withSegments(Collection<CoreNetworkSegment> segments) {
        this.setSegments(segments);
        return this;
    }

    public List<CoreNetworkEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(Collection<CoreNetworkEdge> edges) {
        if (edges == null) {
            this.edges = null;
            return;
        }
        this.edges = new ArrayList<CoreNetworkEdge>(edges);
    }

    public CoreNetwork withEdges(CoreNetworkEdge ... edges) {
        if (this.edges == null) {
            this.setEdges(new ArrayList<CoreNetworkEdge>(edges.length));
        }
        for (CoreNetworkEdge ele : edges) {
            this.edges.add(ele);
        }
        return this;
    }

    public CoreNetwork withEdges(Collection<CoreNetworkEdge> edges) {
        this.setEdges(edges);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CoreNetwork withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CoreNetwork withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getCoreNetworkId() != null) {
            sb.append("CoreNetworkId: ").append(this.getCoreNetworkId()).append(",");
        }
        if (this.getCoreNetworkArn() != null) {
            sb.append("CoreNetworkArn: ").append(this.getCoreNetworkArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getSegments() != null) {
            sb.append("Segments: ").append(this.getSegments()).append(",");
        }
        if (this.getEdges() != null) {
            sb.append("Edges: ").append(this.getEdges()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetwork)) {
            return false;
        }
        CoreNetwork other = (CoreNetwork)obj;
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getCoreNetworkId() == null ^ this.getCoreNetworkId() == null) {
            return false;
        }
        if (other.getCoreNetworkId() != null && !other.getCoreNetworkId().equals(this.getCoreNetworkId())) {
            return false;
        }
        if (other.getCoreNetworkArn() == null ^ this.getCoreNetworkArn() == null) {
            return false;
        }
        if (other.getCoreNetworkArn() != null && !other.getCoreNetworkArn().equals(this.getCoreNetworkArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getSegments() == null ^ this.getSegments() == null) {
            return false;
        }
        if (other.getSegments() != null && !other.getSegments().equals(this.getSegments())) {
            return false;
        }
        if (other.getEdges() == null ^ this.getEdges() == null) {
            return false;
        }
        if (other.getEdges() != null && !other.getEdges().equals(this.getEdges())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getCoreNetworkId() == null ? 0 : this.getCoreNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getCoreNetworkArn() == null ? 0 : this.getCoreNetworkArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getSegments() == null ? 0 : this.getSegments().hashCode());
        hashCode = 31 * hashCode + (this.getEdges() == null ? 0 : this.getEdges().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CoreNetwork clone() {
        try {
            return (CoreNetwork)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoreNetworkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

