/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.GeneratedRulesType;
import com.amazonaws.services.networkfirewall.model.TargetType;
import com.amazonaws.services.networkfirewall.model.transform.RulesSourceListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RulesSourceList
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> targets;
    private List<String> targetTypes;
    private String generatedRulesType;

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public RulesSourceList withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public RulesSourceList withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public List<String> getTargetTypes() {
        return this.targetTypes;
    }

    public void setTargetTypes(Collection<String> targetTypes) {
        if (targetTypes == null) {
            this.targetTypes = null;
            return;
        }
        this.targetTypes = new ArrayList<String>(targetTypes);
    }

    public RulesSourceList withTargetTypes(String ... targetTypes) {
        if (this.targetTypes == null) {
            this.setTargetTypes(new ArrayList<String>(targetTypes.length));
        }
        for (String ele : targetTypes) {
            this.targetTypes.add(ele);
        }
        return this;
    }

    public RulesSourceList withTargetTypes(Collection<String> targetTypes) {
        this.setTargetTypes(targetTypes);
        return this;
    }

    public RulesSourceList withTargetTypes(TargetType ... targetTypes) {
        ArrayList<String> targetTypesCopy = new ArrayList<String>(targetTypes.length);
        for (TargetType value : targetTypes) {
            targetTypesCopy.add(value.toString());
        }
        if (this.getTargetTypes() == null) {
            this.setTargetTypes(targetTypesCopy);
        } else {
            this.getTargetTypes().addAll(targetTypesCopy);
        }
        return this;
    }

    public void setGeneratedRulesType(String generatedRulesType) {
        this.generatedRulesType = generatedRulesType;
    }

    public String getGeneratedRulesType() {
        return this.generatedRulesType;
    }

    public RulesSourceList withGeneratedRulesType(String generatedRulesType) {
        this.setGeneratedRulesType(generatedRulesType);
        return this;
    }

    public RulesSourceList withGeneratedRulesType(GeneratedRulesType generatedRulesType) {
        this.generatedRulesType = generatedRulesType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTargetTypes() != null) {
            sb.append("TargetTypes: ").append(this.getTargetTypes()).append(",");
        }
        if (this.getGeneratedRulesType() != null) {
            sb.append("GeneratedRulesType: ").append(this.getGeneratedRulesType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesSourceList)) {
            return false;
        }
        RulesSourceList other = (RulesSourceList)obj;
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTargetTypes() == null ^ this.getTargetTypes() == null) {
            return false;
        }
        if (other.getTargetTypes() != null && !other.getTargetTypes().equals(this.getTargetTypes())) {
            return false;
        }
        if (other.getGeneratedRulesType() == null ^ this.getGeneratedRulesType() == null) {
            return false;
        }
        return other.getGeneratedRulesType() == null || other.getGeneratedRulesType().equals(this.getGeneratedRulesType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTypes() == null ? 0 : this.getTargetTypes().hashCode());
        hashCode = 31 * hashCode + (this.getGeneratedRulesType() == null ? 0 : this.getGeneratedRulesType().hashCode());
        return hashCode;
    }

    public RulesSourceList clone() {
        try {
            return (RulesSourceList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RulesSourceListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

