/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkfirewall.model.MatchAttributes;
import java.util.List;

@SdkInternalApi
public class MatchAttributesMarshaller {
    private static final MarshallingInfo<List> SOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sources").build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destinations").build();
    private static final MarshallingInfo<List> SOURCEPORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourcePorts").build();
    private static final MarshallingInfo<List> DESTINATIONPORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationPorts").build();
    private static final MarshallingInfo<List> PROTOCOLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocols").build();
    private static final MarshallingInfo<List> TCPFLAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TCPFlags").build();
    private static final MatchAttributesMarshaller instance = new MatchAttributesMarshaller();

    public static MatchAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(MatchAttributes matchAttributes, ProtocolMarshaller protocolMarshaller) {
        if (matchAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(matchAttributes.getSources(), SOURCES_BINDING);
            protocolMarshaller.marshall(matchAttributes.getDestinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall(matchAttributes.getSourcePorts(), SOURCEPORTS_BINDING);
            protocolMarshaller.marshall(matchAttributes.getDestinationPorts(), DESTINATIONPORTS_BINDING);
            protocolMarshaller.marshall(matchAttributes.getProtocols(), PROTOCOLS_BINDING);
            protocolMarshaller.marshall(matchAttributes.getTCPFlags(), TCPFLAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

