/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.Header;
import com.amazonaws.services.networkfirewall.model.RuleOption;
import com.amazonaws.services.networkfirewall.model.StatefulAction;
import com.amazonaws.services.networkfirewall.model.transform.StatefulRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatefulRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String action;
    private Header header;
    private List<RuleOption> ruleOptions;

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public StatefulRule withAction(String action) {
        this.setAction(action);
        return this;
    }

    public StatefulRule withAction(StatefulAction action) {
        this.action = action.toString();
        return this;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public StatefulRule withHeader(Header header) {
        this.setHeader(header);
        return this;
    }

    public List<RuleOption> getRuleOptions() {
        return this.ruleOptions;
    }

    public void setRuleOptions(Collection<RuleOption> ruleOptions) {
        if (ruleOptions == null) {
            this.ruleOptions = null;
            return;
        }
        this.ruleOptions = new ArrayList<RuleOption>(ruleOptions);
    }

    public StatefulRule withRuleOptions(RuleOption ... ruleOptions) {
        if (this.ruleOptions == null) {
            this.setRuleOptions(new ArrayList<RuleOption>(ruleOptions.length));
        }
        for (RuleOption ele : ruleOptions) {
            this.ruleOptions.add(ele);
        }
        return this;
    }

    public StatefulRule withRuleOptions(Collection<RuleOption> ruleOptions) {
        this.setRuleOptions(ruleOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getHeader() != null) {
            sb.append("Header: ").append(this.getHeader()).append(",");
        }
        if (this.getRuleOptions() != null) {
            sb.append("RuleOptions: ").append(this.getRuleOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulRule)) {
            return false;
        }
        StatefulRule other = (StatefulRule)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getHeader() == null ^ this.getHeader() == null) {
            return false;
        }
        if (other.getHeader() != null && !other.getHeader().equals(this.getHeader())) {
            return false;
        }
        if (other.getRuleOptions() == null ^ this.getRuleOptions() == null) {
            return false;
        }
        return other.getRuleOptions() == null || other.getRuleOptions().equals(this.getRuleOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getHeader() == null ? 0 : this.getHeader().hashCode());
        hashCode = 31 * hashCode + (this.getRuleOptions() == null ? 0 : this.getRuleOptions().hashCode());
        return hashCode;
    }

    public StatefulRule clone() {
        try {
            return (StatefulRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatefulRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

