/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkfirewall.model.Firewall;
import java.util.List;

@SdkInternalApi
public class FirewallMarshaller {
    private static final MarshallingInfo<String> FIREWALLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirewallName").build();
    private static final MarshallingInfo<String> FIREWALLARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirewallArn").build();
    private static final MarshallingInfo<String> FIREWALLPOLICYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirewallPolicyArn").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<List> SUBNETMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetMappings").build();
    private static final MarshallingInfo<Boolean> DELETEPROTECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteProtection").build();
    private static final MarshallingInfo<Boolean> SUBNETCHANGEPROTECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetChangeProtection").build();
    private static final MarshallingInfo<Boolean> FIREWALLPOLICYCHANGEPROTECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirewallPolicyChangeProtection").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> FIREWALLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirewallId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final FirewallMarshaller instance = new FirewallMarshaller();

    public static FirewallMarshaller getInstance() {
        return instance;
    }

    public void marshall(Firewall firewall, ProtocolMarshaller protocolMarshaller) {
        if (firewall == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)firewall.getFirewallName(), FIREWALLNAME_BINDING);
            protocolMarshaller.marshall((Object)firewall.getFirewallArn(), FIREWALLARN_BINDING);
            protocolMarshaller.marshall((Object)firewall.getFirewallPolicyArn(), FIREWALLPOLICYARN_BINDING);
            protocolMarshaller.marshall((Object)firewall.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(firewall.getSubnetMappings(), SUBNETMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)firewall.getDeleteProtection(), DELETEPROTECTION_BINDING);
            protocolMarshaller.marshall((Object)firewall.getSubnetChangeProtection(), SUBNETCHANGEPROTECTION_BINDING);
            protocolMarshaller.marshall((Object)firewall.getFirewallPolicyChangeProtection(), FIREWALLPOLICYCHANGEPROTECTION_BINDING);
            protocolMarshaller.marshall((Object)firewall.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)firewall.getFirewallId(), FIREWALLID_BINDING);
            protocolMarshaller.marshall(firewall.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

