/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model.transform;

import com.amazonaws.services.migrationhubstrategyrecommendations.model.S3Object;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ObjectJsonUnmarshaller
implements Unmarshaller<S3Object, JsonUnmarshallerContext> {
    private static S3ObjectJsonUnmarshaller instance;

    public S3Object unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Object s3Object = new S3Object();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("s3Bucket", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setS3Bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3key", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setS3key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Object;
    }

    public static S3ObjectJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectJsonUnmarshaller();
        }
        return instance;
    }
}

