/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.migrationhuborchestrator;

import javax.annotation.Generated;

import com.amazonaws.services.migrationhuborchestrator.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMigrationHubOrchestrator}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMigrationHubOrchestrator implements AWSMigrationHubOrchestrator {

    protected AbstractAWSMigrationHubOrchestrator() {
    }

    @Override
    public CreateWorkflowResult createWorkflow(CreateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkflowStepResult createWorkflowStep(CreateWorkflowStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkflowStepGroupResult createWorkflowStepGroup(CreateWorkflowStepGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowResult deleteWorkflow(DeleteWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowStepResult deleteWorkflowStep(DeleteWorkflowStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowStepGroupResult deleteWorkflowStepGroup(DeleteWorkflowStepGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateStepResult getTemplateStep(GetTemplateStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateStepGroupResult getTemplateStepGroup(GetTemplateStepGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowResult getWorkflow(GetWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowStepResult getWorkflowStep(GetWorkflowStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowStepGroupResult getWorkflowStepGroup(GetWorkflowStepGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPluginsResult listPlugins(ListPluginsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateStepGroupsResult listTemplateStepGroups(ListTemplateStepGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateStepsResult listTemplateSteps(ListTemplateStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplatesResult listTemplates(ListTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowStepGroupsResult listWorkflowStepGroups(ListWorkflowStepGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowStepsResult listWorkflowSteps(ListWorkflowStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowsResult listWorkflows(ListWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RetryWorkflowStepResult retryWorkflowStep(RetryWorkflowStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartWorkflowResult startWorkflow(StartWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopWorkflowResult stopWorkflow(StopWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkflowResult updateWorkflow(UpdateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkflowStepResult updateWorkflowStep(UpdateWorkflowStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkflowStepGroupResult updateWorkflowStepGroup(UpdateWorkflowStepGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
