/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubconfig;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.migrationhubconfig.AWSMigrationHubConfig;
import com.amazonaws.services.migrationhubconfig.AWSMigrationHubConfigClientBuilder;
import com.amazonaws.services.migrationhubconfig.model.AWSMigrationHubConfigException;
import com.amazonaws.services.migrationhubconfig.model.CreateHomeRegionControlRequest;
import com.amazonaws.services.migrationhubconfig.model.CreateHomeRegionControlResult;
import com.amazonaws.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import com.amazonaws.services.migrationhubconfig.model.DescribeHomeRegionControlsResult;
import com.amazonaws.services.migrationhubconfig.model.GetHomeRegionRequest;
import com.amazonaws.services.migrationhubconfig.model.GetHomeRegionResult;
import com.amazonaws.services.migrationhubconfig.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.CreateHomeRegionControlRequestProtocolMarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.CreateHomeRegionControlResultJsonUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.DescribeHomeRegionControlsRequestProtocolMarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.DescribeHomeRegionControlsResultJsonUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.DryRunOperationExceptionUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.GetHomeRegionRequestProtocolMarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.GetHomeRegionResultJsonUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.migrationhubconfig.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMigrationHubConfigClient
extends AmazonWebServiceClient
implements AWSMigrationHubConfig {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMigrationHubConfig.class);
    private static final String DEFAULT_SIGNING_NAME = "mgh";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DryRunOperation").withExceptionUnmarshaller((JsonErrorUnmarshaller)DryRunOperationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMigrationHubConfigException.class));

    public static AWSMigrationHubConfigClientBuilder builder() {
        return AWSMigrationHubConfigClientBuilder.standard();
    }

    AWSMigrationHubConfigClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMigrationHubConfigClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("migrationhub-config");
        this.setEndpoint("migrationhub-config.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/migrationhubconfig/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/migrationhubconfig/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateHomeRegionControlResult createHomeRegionControl(CreateHomeRegionControlRequest request) {
        request = (CreateHomeRegionControlRequest)this.beforeClientExecution(request);
        return this.executeCreateHomeRegionControl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHomeRegionControlResult executeCreateHomeRegionControl(CreateHomeRegionControlRequest createHomeRegionControlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHomeRegionControlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHomeRegionControlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHomeRegionControlRequestProtocolMarshaller(protocolFactory).marshall((CreateHomeRegionControlRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHomeRegionControlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MigrationHub Config");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHomeRegionControl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHomeRegionControlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHomeRegionControlResult createHomeRegionControlResult = (CreateHomeRegionControlResult)response.getAwsResponse();
            return createHomeRegionControlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHomeRegionControlsResult describeHomeRegionControls(DescribeHomeRegionControlsRequest request) {
        request = (DescribeHomeRegionControlsRequest)this.beforeClientExecution(request);
        return this.executeDescribeHomeRegionControls(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHomeRegionControlsResult executeDescribeHomeRegionControls(DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHomeRegionControlsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHomeRegionControlsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHomeRegionControlsRequestProtocolMarshaller(protocolFactory).marshall((DescribeHomeRegionControlsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHomeRegionControlsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MigrationHub Config");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHomeRegionControls");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHomeRegionControlsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHomeRegionControlsResult describeHomeRegionControlsResult = (DescribeHomeRegionControlsResult)response.getAwsResponse();
            return describeHomeRegionControlsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetHomeRegionResult getHomeRegion(GetHomeRegionRequest request) {
        request = (GetHomeRegionRequest)this.beforeClientExecution(request);
        return this.executeGetHomeRegion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetHomeRegionResult executeGetHomeRegion(GetHomeRegionRequest getHomeRegionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getHomeRegionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetHomeRegionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetHomeRegionRequestProtocolMarshaller(protocolFactory).marshall((GetHomeRegionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getHomeRegionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MigrationHub Config");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetHomeRegion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetHomeRegionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetHomeRegionResult getHomeRegionResult = (GetHomeRegionResult)response.getAwsResponse();
            return getHomeRegionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

