/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.memorydb.AmazonMemoryDBAsync;
import com.amazonaws.services.memorydb.AmazonMemoryDBAsyncClientBuilder;
import com.amazonaws.services.memorydb.AmazonMemoryDBClient;
import com.amazonaws.services.memorydb.model.BatchUpdateClusterRequest;
import com.amazonaws.services.memorydb.model.BatchUpdateClusterResult;
import com.amazonaws.services.memorydb.model.CopySnapshotRequest;
import com.amazonaws.services.memorydb.model.CopySnapshotResult;
import com.amazonaws.services.memorydb.model.CreateACLRequest;
import com.amazonaws.services.memorydb.model.CreateACLResult;
import com.amazonaws.services.memorydb.model.CreateClusterRequest;
import com.amazonaws.services.memorydb.model.CreateClusterResult;
import com.amazonaws.services.memorydb.model.CreateParameterGroupRequest;
import com.amazonaws.services.memorydb.model.CreateParameterGroupResult;
import com.amazonaws.services.memorydb.model.CreateSnapshotRequest;
import com.amazonaws.services.memorydb.model.CreateSnapshotResult;
import com.amazonaws.services.memorydb.model.CreateSubnetGroupRequest;
import com.amazonaws.services.memorydb.model.CreateSubnetGroupResult;
import com.amazonaws.services.memorydb.model.CreateUserRequest;
import com.amazonaws.services.memorydb.model.CreateUserResult;
import com.amazonaws.services.memorydb.model.DeleteACLRequest;
import com.amazonaws.services.memorydb.model.DeleteACLResult;
import com.amazonaws.services.memorydb.model.DeleteClusterRequest;
import com.amazonaws.services.memorydb.model.DeleteClusterResult;
import com.amazonaws.services.memorydb.model.DeleteParameterGroupRequest;
import com.amazonaws.services.memorydb.model.DeleteParameterGroupResult;
import com.amazonaws.services.memorydb.model.DeleteSnapshotRequest;
import com.amazonaws.services.memorydb.model.DeleteSnapshotResult;
import com.amazonaws.services.memorydb.model.DeleteSubnetGroupRequest;
import com.amazonaws.services.memorydb.model.DeleteSubnetGroupResult;
import com.amazonaws.services.memorydb.model.DeleteUserRequest;
import com.amazonaws.services.memorydb.model.DeleteUserResult;
import com.amazonaws.services.memorydb.model.DescribeACLsRequest;
import com.amazonaws.services.memorydb.model.DescribeACLsResult;
import com.amazonaws.services.memorydb.model.DescribeClustersRequest;
import com.amazonaws.services.memorydb.model.DescribeClustersResult;
import com.amazonaws.services.memorydb.model.DescribeEngineVersionsRequest;
import com.amazonaws.services.memorydb.model.DescribeEngineVersionsResult;
import com.amazonaws.services.memorydb.model.DescribeEventsRequest;
import com.amazonaws.services.memorydb.model.DescribeEventsResult;
import com.amazonaws.services.memorydb.model.DescribeParameterGroupsRequest;
import com.amazonaws.services.memorydb.model.DescribeParameterGroupsResult;
import com.amazonaws.services.memorydb.model.DescribeParametersRequest;
import com.amazonaws.services.memorydb.model.DescribeParametersResult;
import com.amazonaws.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import com.amazonaws.services.memorydb.model.DescribeReservedNodesOfferingsResult;
import com.amazonaws.services.memorydb.model.DescribeReservedNodesRequest;
import com.amazonaws.services.memorydb.model.DescribeReservedNodesResult;
import com.amazonaws.services.memorydb.model.DescribeServiceUpdatesRequest;
import com.amazonaws.services.memorydb.model.DescribeServiceUpdatesResult;
import com.amazonaws.services.memorydb.model.DescribeSnapshotsRequest;
import com.amazonaws.services.memorydb.model.DescribeSnapshotsResult;
import com.amazonaws.services.memorydb.model.DescribeSubnetGroupsRequest;
import com.amazonaws.services.memorydb.model.DescribeSubnetGroupsResult;
import com.amazonaws.services.memorydb.model.DescribeUsersRequest;
import com.amazonaws.services.memorydb.model.DescribeUsersResult;
import com.amazonaws.services.memorydb.model.FailoverShardRequest;
import com.amazonaws.services.memorydb.model.FailoverShardResult;
import com.amazonaws.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import com.amazonaws.services.memorydb.model.ListAllowedNodeTypeUpdatesResult;
import com.amazonaws.services.memorydb.model.ListTagsRequest;
import com.amazonaws.services.memorydb.model.ListTagsResult;
import com.amazonaws.services.memorydb.model.PurchaseReservedNodesOfferingRequest;
import com.amazonaws.services.memorydb.model.PurchaseReservedNodesOfferingResult;
import com.amazonaws.services.memorydb.model.ResetParameterGroupRequest;
import com.amazonaws.services.memorydb.model.ResetParameterGroupResult;
import com.amazonaws.services.memorydb.model.TagResourceRequest;
import com.amazonaws.services.memorydb.model.TagResourceResult;
import com.amazonaws.services.memorydb.model.UntagResourceRequest;
import com.amazonaws.services.memorydb.model.UntagResourceResult;
import com.amazonaws.services.memorydb.model.UpdateACLRequest;
import com.amazonaws.services.memorydb.model.UpdateACLResult;
import com.amazonaws.services.memorydb.model.UpdateClusterRequest;
import com.amazonaws.services.memorydb.model.UpdateClusterResult;
import com.amazonaws.services.memorydb.model.UpdateParameterGroupRequest;
import com.amazonaws.services.memorydb.model.UpdateParameterGroupResult;
import com.amazonaws.services.memorydb.model.UpdateSubnetGroupRequest;
import com.amazonaws.services.memorydb.model.UpdateSubnetGroupResult;
import com.amazonaws.services.memorydb.model.UpdateUserRequest;
import com.amazonaws.services.memorydb.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMemoryDBAsyncClient
extends AmazonMemoryDBClient
implements AmazonMemoryDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMemoryDBAsyncClientBuilder asyncBuilder() {
        return AmazonMemoryDBAsyncClientBuilder.standard();
    }

    AmazonMemoryDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonMemoryDBAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchUpdateClusterResult> batchUpdateClusterAsync(BatchUpdateClusterRequest request) {
        return this.batchUpdateClusterAsync(request, null);
    }

    @Override
    public Future<BatchUpdateClusterResult> batchUpdateClusterAsync(BatchUpdateClusterRequest request, final AsyncHandler<BatchUpdateClusterRequest, BatchUpdateClusterResult> asyncHandler) {
        final BatchUpdateClusterRequest finalRequest = (BatchUpdateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateClusterResult>(){

            @Override
            public BatchUpdateClusterResult call() throws Exception {
                BatchUpdateClusterResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeBatchUpdateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CopySnapshotResult> copySnapshotAsync(CopySnapshotRequest request) {
        return this.copySnapshotAsync(request, null);
    }

    @Override
    public Future<CopySnapshotResult> copySnapshotAsync(CopySnapshotRequest request, final AsyncHandler<CopySnapshotRequest, CopySnapshotResult> asyncHandler) {
        final CopySnapshotRequest finalRequest = (CopySnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CopySnapshotResult>(){

            @Override
            public CopySnapshotResult call() throws Exception {
                CopySnapshotResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCopySnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateACLResult> createACLAsync(CreateACLRequest request) {
        return this.createACLAsync(request, null);
    }

    @Override
    public Future<CreateACLResult> createACLAsync(CreateACLRequest request, final AsyncHandler<CreateACLRequest, CreateACLResult> asyncHandler) {
        final CreateACLRequest finalRequest = (CreateACLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateACLResult>(){

            @Override
            public CreateACLResult call() throws Exception {
                CreateACLResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateACL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateParameterGroupResult> createParameterGroupAsync(CreateParameterGroupRequest request) {
        return this.createParameterGroupAsync(request, null);
    }

    @Override
    public Future<CreateParameterGroupResult> createParameterGroupAsync(CreateParameterGroupRequest request, final AsyncHandler<CreateParameterGroupRequest, CreateParameterGroupResult> asyncHandler) {
        final CreateParameterGroupRequest finalRequest = (CreateParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateParameterGroupResult>(){

            @Override
            public CreateParameterGroupResult call() throws Exception {
                CreateParameterGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        final CreateSnapshotRequest finalRequest = (CreateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSubnetGroupResult> createSubnetGroupAsync(CreateSubnetGroupRequest request) {
        return this.createSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CreateSubnetGroupResult> createSubnetGroupAsync(CreateSubnetGroupRequest request, final AsyncHandler<CreateSubnetGroupRequest, CreateSubnetGroupResult> asyncHandler) {
        final CreateSubnetGroupRequest finalRequest = (CreateSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSubnetGroupResult>(){

            @Override
            public CreateSubnetGroupResult call() throws Exception {
                CreateSubnetGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteACLResult> deleteACLAsync(DeleteACLRequest request) {
        return this.deleteACLAsync(request, null);
    }

    @Override
    public Future<DeleteACLResult> deleteACLAsync(DeleteACLRequest request, final AsyncHandler<DeleteACLRequest, DeleteACLResult> asyncHandler) {
        final DeleteACLRequest finalRequest = (DeleteACLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteACLResult>(){

            @Override
            public DeleteACLResult call() throws Exception {
                DeleteACLResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteACL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteParameterGroupResult> deleteParameterGroupAsync(DeleteParameterGroupRequest request) {
        return this.deleteParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteParameterGroupResult> deleteParameterGroupAsync(DeleteParameterGroupRequest request, final AsyncHandler<DeleteParameterGroupRequest, DeleteParameterGroupResult> asyncHandler) {
        final DeleteParameterGroupRequest finalRequest = (DeleteParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteParameterGroupResult>(){

            @Override
            public DeleteParameterGroupResult call() throws Exception {
                DeleteParameterGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) {
        final DeleteSnapshotRequest finalRequest = (DeleteSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                DeleteSnapshotResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSubnetGroupResult> deleteSubnetGroupAsync(DeleteSubnetGroupRequest request) {
        return this.deleteSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteSubnetGroupResult> deleteSubnetGroupAsync(DeleteSubnetGroupRequest request, final AsyncHandler<DeleteSubnetGroupRequest, DeleteSubnetGroupResult> asyncHandler) {
        final DeleteSubnetGroupRequest finalRequest = (DeleteSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSubnetGroupResult>(){

            @Override
            public DeleteSubnetGroupResult call() throws Exception {
                DeleteSubnetGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeACLsResult> describeACLsAsync(DescribeACLsRequest request) {
        return this.describeACLsAsync(request, null);
    }

    @Override
    public Future<DescribeACLsResult> describeACLsAsync(DescribeACLsRequest request, final AsyncHandler<DescribeACLsRequest, DescribeACLsResult> asyncHandler) {
        final DescribeACLsRequest finalRequest = (DescribeACLsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeACLsResult>(){

            @Override
            public DescribeACLsResult call() throws Exception {
                DescribeACLsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeACLs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        final DescribeClustersRequest finalRequest = (DescribeClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEngineVersionsResult> describeEngineVersionsAsync(DescribeEngineVersionsRequest request) {
        return this.describeEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeEngineVersionsResult> describeEngineVersionsAsync(DescribeEngineVersionsRequest request, final AsyncHandler<DescribeEngineVersionsRequest, DescribeEngineVersionsResult> asyncHandler) {
        final DescribeEngineVersionsRequest finalRequest = (DescribeEngineVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEngineVersionsResult>(){

            @Override
            public DescribeEngineVersionsResult call() throws Exception {
                DescribeEngineVersionsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeEngineVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeParameterGroupsResult> describeParameterGroupsAsync(DescribeParameterGroupsRequest request) {
        return this.describeParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeParameterGroupsResult> describeParameterGroupsAsync(DescribeParameterGroupsRequest request, final AsyncHandler<DescribeParameterGroupsRequest, DescribeParameterGroupsResult> asyncHandler) {
        final DescribeParameterGroupsRequest finalRequest = (DescribeParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeParameterGroupsResult>(){

            @Override
            public DescribeParameterGroupsResult call() throws Exception {
                DescribeParameterGroupsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeParametersResult> describeParametersAsync(DescribeParametersRequest request) {
        return this.describeParametersAsync(request, null);
    }

    @Override
    public Future<DescribeParametersResult> describeParametersAsync(DescribeParametersRequest request, final AsyncHandler<DescribeParametersRequest, DescribeParametersResult> asyncHandler) {
        final DescribeParametersRequest finalRequest = (DescribeParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeParametersResult>(){

            @Override
            public DescribeParametersResult call() throws Exception {
                DescribeParametersResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(DescribeReservedNodesRequest request) {
        return this.describeReservedNodesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(DescribeReservedNodesRequest request, final AsyncHandler<DescribeReservedNodesRequest, DescribeReservedNodesResult> asyncHandler) {
        final DescribeReservedNodesRequest finalRequest = (DescribeReservedNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                DescribeReservedNodesResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeReservedNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesOfferingsResult> describeReservedNodesOfferingsAsync(DescribeReservedNodesOfferingsRequest request) {
        return this.describeReservedNodesOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedNodesOfferingsResult> describeReservedNodesOfferingsAsync(DescribeReservedNodesOfferingsRequest request, final AsyncHandler<DescribeReservedNodesOfferingsRequest, DescribeReservedNodesOfferingsResult> asyncHandler) {
        final DescribeReservedNodesOfferingsRequest finalRequest = (DescribeReservedNodesOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedNodesOfferingsResult>(){

            @Override
            public DescribeReservedNodesOfferingsResult call() throws Exception {
                DescribeReservedNodesOfferingsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeReservedNodesOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServiceUpdatesResult> describeServiceUpdatesAsync(DescribeServiceUpdatesRequest request) {
        return this.describeServiceUpdatesAsync(request, null);
    }

    @Override
    public Future<DescribeServiceUpdatesResult> describeServiceUpdatesAsync(DescribeServiceUpdatesRequest request, final AsyncHandler<DescribeServiceUpdatesRequest, DescribeServiceUpdatesResult> asyncHandler) {
        final DescribeServiceUpdatesRequest finalRequest = (DescribeServiceUpdatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServiceUpdatesResult>(){

            @Override
            public DescribeServiceUpdatesResult call() throws Exception {
                DescribeServiceUpdatesResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeServiceUpdates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        final DescribeSnapshotsRequest finalRequest = (DescribeSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubnetGroupsResult> describeSubnetGroupsAsync(DescribeSubnetGroupsRequest request) {
        return this.describeSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeSubnetGroupsResult> describeSubnetGroupsAsync(DescribeSubnetGroupsRequest request, final AsyncHandler<DescribeSubnetGroupsRequest, DescribeSubnetGroupsResult> asyncHandler) {
        final DescribeSubnetGroupsRequest finalRequest = (DescribeSubnetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSubnetGroupsResult>(){

            @Override
            public DescribeSubnetGroupsResult call() throws Exception {
                DescribeSubnetGroupsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeSubnetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request) {
        return this.describeUsersAsync(request, null);
    }

    @Override
    public Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request, final AsyncHandler<DescribeUsersRequest, DescribeUsersResult> asyncHandler) {
        final DescribeUsersRequest finalRequest = (DescribeUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUsersResult>(){

            @Override
            public DescribeUsersResult call() throws Exception {
                DescribeUsersResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeDescribeUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<FailoverShardResult> failoverShardAsync(FailoverShardRequest request) {
        return this.failoverShardAsync(request, null);
    }

    @Override
    public Future<FailoverShardResult> failoverShardAsync(FailoverShardRequest request, final AsyncHandler<FailoverShardRequest, FailoverShardResult> asyncHandler) {
        final FailoverShardRequest finalRequest = (FailoverShardRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<FailoverShardResult>(){

            @Override
            public FailoverShardResult call() throws Exception {
                FailoverShardResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeFailoverShard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAllowedNodeTypeUpdatesResult> listAllowedNodeTypeUpdatesAsync(ListAllowedNodeTypeUpdatesRequest request) {
        return this.listAllowedNodeTypeUpdatesAsync(request, null);
    }

    @Override
    public Future<ListAllowedNodeTypeUpdatesResult> listAllowedNodeTypeUpdatesAsync(ListAllowedNodeTypeUpdatesRequest request, final AsyncHandler<ListAllowedNodeTypeUpdatesRequest, ListAllowedNodeTypeUpdatesResult> asyncHandler) {
        final ListAllowedNodeTypeUpdatesRequest finalRequest = (ListAllowedNodeTypeUpdatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAllowedNodeTypeUpdatesResult>(){

            @Override
            public ListAllowedNodeTypeUpdatesResult call() throws Exception {
                ListAllowedNodeTypeUpdatesResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeListAllowedNodeTypeUpdates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseReservedNodesOfferingResult> purchaseReservedNodesOfferingAsync(PurchaseReservedNodesOfferingRequest request) {
        return this.purchaseReservedNodesOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseReservedNodesOfferingResult> purchaseReservedNodesOfferingAsync(PurchaseReservedNodesOfferingRequest request, final AsyncHandler<PurchaseReservedNodesOfferingRequest, PurchaseReservedNodesOfferingResult> asyncHandler) {
        final PurchaseReservedNodesOfferingRequest finalRequest = (PurchaseReservedNodesOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurchaseReservedNodesOfferingResult>(){

            @Override
            public PurchaseReservedNodesOfferingResult call() throws Exception {
                PurchaseReservedNodesOfferingResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executePurchaseReservedNodesOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetParameterGroupResult> resetParameterGroupAsync(ResetParameterGroupRequest request) {
        return this.resetParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetParameterGroupResult> resetParameterGroupAsync(ResetParameterGroupRequest request, final AsyncHandler<ResetParameterGroupRequest, ResetParameterGroupResult> asyncHandler) {
        final ResetParameterGroupRequest finalRequest = (ResetParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetParameterGroupResult>(){

            @Override
            public ResetParameterGroupResult call() throws Exception {
                ResetParameterGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeResetParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateACLResult> updateACLAsync(UpdateACLRequest request) {
        return this.updateACLAsync(request, null);
    }

    @Override
    public Future<UpdateACLResult> updateACLAsync(UpdateACLRequest request, final AsyncHandler<UpdateACLRequest, UpdateACLResult> asyncHandler) {
        final UpdateACLRequest finalRequest = (UpdateACLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateACLResult>(){

            @Override
            public UpdateACLResult call() throws Exception {
                UpdateACLResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUpdateACL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterAsync(request, null);
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request, final AsyncHandler<UpdateClusterRequest, UpdateClusterResult> asyncHandler) {
        final UpdateClusterRequest finalRequest = (UpdateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterResult>(){

            @Override
            public UpdateClusterResult call() throws Exception {
                UpdateClusterResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUpdateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateParameterGroupResult> updateParameterGroupAsync(UpdateParameterGroupRequest request) {
        return this.updateParameterGroupAsync(request, null);
    }

    @Override
    public Future<UpdateParameterGroupResult> updateParameterGroupAsync(UpdateParameterGroupRequest request, final AsyncHandler<UpdateParameterGroupRequest, UpdateParameterGroupResult> asyncHandler) {
        final UpdateParameterGroupRequest finalRequest = (UpdateParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateParameterGroupResult>(){

            @Override
            public UpdateParameterGroupResult call() throws Exception {
                UpdateParameterGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUpdateParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSubnetGroupResult> updateSubnetGroupAsync(UpdateSubnetGroupRequest request) {
        return this.updateSubnetGroupAsync(request, null);
    }

    @Override
    public Future<UpdateSubnetGroupResult> updateSubnetGroupAsync(UpdateSubnetGroupRequest request, final AsyncHandler<UpdateSubnetGroupRequest, UpdateSubnetGroupResult> asyncHandler) {
        final UpdateSubnetGroupRequest finalRequest = (UpdateSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSubnetGroupResult>(){

            @Override
            public UpdateSubnetGroupResult call() throws Exception {
                UpdateSubnetGroupResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUpdateSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AmazonMemoryDBAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

