/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.memorydb.model.ClusterConfiguration;
import java.util.List;

@SdkInternalApi
public class ClusterConfigurationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<String> MAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaintenanceWindow").build();
    private static final MarshallingInfo<String> TOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicArn").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final MarshallingInfo<String> PARAMETERGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupName").build();
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<Integer> SNAPSHOTRETENTIONLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotRetentionLimit").build();
    private static final MarshallingInfo<String> SNAPSHOTWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotWindow").build();
    private static final MarshallingInfo<Integer> NUMSHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumShards").build();
    private static final MarshallingInfo<List> SHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shards").build();
    private static final ClusterConfigurationMarshaller instance = new ClusterConfigurationMarshaller();

    public static ClusterConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterConfiguration clusterConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (clusterConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterConfiguration.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getNodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getMaintenanceWindow(), MAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getTopicArn(), TOPICARN_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getPort(), PORT_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getParameterGroupName(), PARAMETERGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getSubnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getSnapshotRetentionLimit(), SNAPSHOTRETENTIONLIMIT_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getSnapshotWindow(), SNAPSHOTWINDOW_BINDING);
            protocolMarshaller.marshall((Object)clusterConfiguration.getNumShards(), NUMSHARDS_BINDING);
            protocolMarshaller.marshall(clusterConfiguration.getShards(), SHARDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

