/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.AZStatus;
import com.amazonaws.services.memorydb.model.ClusterPendingUpdates;
import com.amazonaws.services.memorydb.model.Endpoint;
import com.amazonaws.services.memorydb.model.SecurityGroupMembership;
import com.amazonaws.services.memorydb.model.Shard;
import com.amazonaws.services.memorydb.model.transform.ClusterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String status;
    private ClusterPendingUpdates pendingUpdates;
    private Integer numberOfShards;
    private List<Shard> shards;
    private String availabilityMode;
    private Endpoint clusterEndpoint;
    private String nodeType;
    private String engineVersion;
    private String enginePatchVersion;
    private String parameterGroupName;
    private String parameterGroupStatus;
    private List<SecurityGroupMembership> securityGroups;
    private String subnetGroupName;
    private Boolean tLSEnabled;
    private String kmsKeyId;
    private String aRN;
    private String snsTopicArn;
    private String snsTopicStatus;
    private Integer snapshotRetentionLimit;
    private String maintenanceWindow;
    private String snapshotWindow;
    private String aCLName;
    private Boolean autoMinorVersionUpgrade;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Cluster withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Cluster withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Cluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPendingUpdates(ClusterPendingUpdates pendingUpdates) {
        this.pendingUpdates = pendingUpdates;
    }

    public ClusterPendingUpdates getPendingUpdates() {
        return this.pendingUpdates;
    }

    public Cluster withPendingUpdates(ClusterPendingUpdates pendingUpdates) {
        this.setPendingUpdates(pendingUpdates);
        return this;
    }

    public void setNumberOfShards(Integer numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    public Cluster withNumberOfShards(Integer numberOfShards) {
        this.setNumberOfShards(numberOfShards);
        return this;
    }

    public List<Shard> getShards() {
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new ArrayList<Shard>(shards);
    }

    public Cluster withShards(Shard ... shards) {
        if (this.shards == null) {
            this.setShards(new ArrayList<Shard>(shards.length));
        }
        for (Shard ele : shards) {
            this.shards.add(ele);
        }
        return this;
    }

    public Cluster withShards(Collection<Shard> shards) {
        this.setShards(shards);
        return this;
    }

    public void setAvailabilityMode(String availabilityMode) {
        this.availabilityMode = availabilityMode;
    }

    public String getAvailabilityMode() {
        return this.availabilityMode;
    }

    public Cluster withAvailabilityMode(String availabilityMode) {
        this.setAvailabilityMode(availabilityMode);
        return this;
    }

    public Cluster withAvailabilityMode(AZStatus availabilityMode) {
        this.availabilityMode = availabilityMode.toString();
        return this;
    }

    public void setClusterEndpoint(Endpoint clusterEndpoint) {
        this.clusterEndpoint = clusterEndpoint;
    }

    public Endpoint getClusterEndpoint() {
        return this.clusterEndpoint;
    }

    public Cluster withClusterEndpoint(Endpoint clusterEndpoint) {
        this.setClusterEndpoint(clusterEndpoint);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public Cluster withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public Cluster withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setEnginePatchVersion(String enginePatchVersion) {
        this.enginePatchVersion = enginePatchVersion;
    }

    public String getEnginePatchVersion() {
        return this.enginePatchVersion;
    }

    public Cluster withEnginePatchVersion(String enginePatchVersion) {
        this.setEnginePatchVersion(enginePatchVersion);
        return this;
    }

    public void setParameterGroupName(String parameterGroupName) {
        this.parameterGroupName = parameterGroupName;
    }

    public String getParameterGroupName() {
        return this.parameterGroupName;
    }

    public Cluster withParameterGroupName(String parameterGroupName) {
        this.setParameterGroupName(parameterGroupName);
        return this;
    }

    public void setParameterGroupStatus(String parameterGroupStatus) {
        this.parameterGroupStatus = parameterGroupStatus;
    }

    public String getParameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public Cluster withParameterGroupStatus(String parameterGroupStatus) {
        this.setParameterGroupStatus(parameterGroupStatus);
        return this;
    }

    public List<SecurityGroupMembership> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<SecurityGroupMembership>(securityGroups);
    }

    public Cluster withSecurityGroups(SecurityGroupMembership ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroupMembership>(securityGroups.length));
        }
        for (SecurityGroupMembership ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public Cluster withSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSubnetGroupName(String subnetGroupName) {
        this.subnetGroupName = subnetGroupName;
    }

    public String getSubnetGroupName() {
        return this.subnetGroupName;
    }

    public Cluster withSubnetGroupName(String subnetGroupName) {
        this.setSubnetGroupName(subnetGroupName);
        return this;
    }

    public void setTLSEnabled(Boolean tLSEnabled) {
        this.tLSEnabled = tLSEnabled;
    }

    public Boolean getTLSEnabled() {
        return this.tLSEnabled;
    }

    public Cluster withTLSEnabled(Boolean tLSEnabled) {
        this.setTLSEnabled(tLSEnabled);
        return this;
    }

    public Boolean isTLSEnabled() {
        return this.tLSEnabled;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Cluster withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public Cluster withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
    }

    public String getSnsTopicArn() {
        return this.snsTopicArn;
    }

    public Cluster withSnsTopicArn(String snsTopicArn) {
        this.setSnsTopicArn(snsTopicArn);
        return this;
    }

    public void setSnsTopicStatus(String snsTopicStatus) {
        this.snsTopicStatus = snsTopicStatus;
    }

    public String getSnsTopicStatus() {
        return this.snsTopicStatus;
    }

    public Cluster withSnsTopicStatus(String snsTopicStatus) {
        this.setSnsTopicStatus(snsTopicStatus);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public Cluster withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setMaintenanceWindow(String maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
    }

    public String getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public Cluster withMaintenanceWindow(String maintenanceWindow) {
        this.setMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public Cluster withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setACLName(String aCLName) {
        this.aCLName = aCLName;
    }

    public String getACLName() {
        return this.aCLName;
    }

    public Cluster withACLName(String aCLName) {
        this.setACLName(aCLName);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Cluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPendingUpdates() != null) {
            sb.append("PendingUpdates: ").append(this.getPendingUpdates()).append(",");
        }
        if (this.getNumberOfShards() != null) {
            sb.append("NumberOfShards: ").append(this.getNumberOfShards()).append(",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: ").append(this.getShards()).append(",");
        }
        if (this.getAvailabilityMode() != null) {
            sb.append("AvailabilityMode: ").append(this.getAvailabilityMode()).append(",");
        }
        if (this.getClusterEndpoint() != null) {
            sb.append("ClusterEndpoint: ").append(this.getClusterEndpoint()).append(",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: ").append(this.getNodeType()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getEnginePatchVersion() != null) {
            sb.append("EnginePatchVersion: ").append(this.getEnginePatchVersion()).append(",");
        }
        if (this.getParameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.getParameterGroupName()).append(",");
        }
        if (this.getParameterGroupStatus() != null) {
            sb.append("ParameterGroupStatus: ").append(this.getParameterGroupStatus()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSubnetGroupName() != null) {
            sb.append("SubnetGroupName: ").append(this.getSubnetGroupName()).append(",");
        }
        if (this.getTLSEnabled() != null) {
            sb.append("TLSEnabled: ").append(this.getTLSEnabled()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getSnsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.getSnsTopicArn()).append(",");
        }
        if (this.getSnsTopicStatus() != null) {
            sb.append("SnsTopicStatus: ").append(this.getSnsTopicStatus()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getMaintenanceWindow() != null) {
            sb.append("MaintenanceWindow: ").append(this.getMaintenanceWindow()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getACLName() != null) {
            sb.append("ACLName: ").append(this.getACLName()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPendingUpdates() == null ^ this.getPendingUpdates() == null) {
            return false;
        }
        if (other.getPendingUpdates() != null && !other.getPendingUpdates().equals(this.getPendingUpdates())) {
            return false;
        }
        if (other.getNumberOfShards() == null ^ this.getNumberOfShards() == null) {
            return false;
        }
        if (other.getNumberOfShards() != null && !other.getNumberOfShards().equals(this.getNumberOfShards())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !other.getShards().equals(this.getShards())) {
            return false;
        }
        if (other.getAvailabilityMode() == null ^ this.getAvailabilityMode() == null) {
            return false;
        }
        if (other.getAvailabilityMode() != null && !other.getAvailabilityMode().equals(this.getAvailabilityMode())) {
            return false;
        }
        if (other.getClusterEndpoint() == null ^ this.getClusterEndpoint() == null) {
            return false;
        }
        if (other.getClusterEndpoint() != null && !other.getClusterEndpoint().equals(this.getClusterEndpoint())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getEnginePatchVersion() == null ^ this.getEnginePatchVersion() == null) {
            return false;
        }
        if (other.getEnginePatchVersion() != null && !other.getEnginePatchVersion().equals(this.getEnginePatchVersion())) {
            return false;
        }
        if (other.getParameterGroupName() == null ^ this.getParameterGroupName() == null) {
            return false;
        }
        if (other.getParameterGroupName() != null && !other.getParameterGroupName().equals(this.getParameterGroupName())) {
            return false;
        }
        if (other.getParameterGroupStatus() == null ^ this.getParameterGroupStatus() == null) {
            return false;
        }
        if (other.getParameterGroupStatus() != null && !other.getParameterGroupStatus().equals(this.getParameterGroupStatus())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSubnetGroupName() == null ^ this.getSubnetGroupName() == null) {
            return false;
        }
        if (other.getSubnetGroupName() != null && !other.getSubnetGroupName().equals(this.getSubnetGroupName())) {
            return false;
        }
        if (other.getTLSEnabled() == null ^ this.getTLSEnabled() == null) {
            return false;
        }
        if (other.getTLSEnabled() != null && !other.getTLSEnabled().equals(this.getTLSEnabled())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getSnsTopicArn() == null ^ this.getSnsTopicArn() == null) {
            return false;
        }
        if (other.getSnsTopicArn() != null && !other.getSnsTopicArn().equals(this.getSnsTopicArn())) {
            return false;
        }
        if (other.getSnsTopicStatus() == null ^ this.getSnsTopicStatus() == null) {
            return false;
        }
        if (other.getSnsTopicStatus() != null && !other.getSnsTopicStatus().equals(this.getSnsTopicStatus())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getMaintenanceWindow() == null ^ this.getMaintenanceWindow() == null) {
            return false;
        }
        if (other.getMaintenanceWindow() != null && !other.getMaintenanceWindow().equals(this.getMaintenanceWindow())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getACLName() == null ^ this.getACLName() == null) {
            return false;
        }
        if (other.getACLName() != null && !other.getACLName().equals(this.getACLName())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        return other.getAutoMinorVersionUpgrade() == null || other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPendingUpdates() == null ? 0 : this.getPendingUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfShards() == null ? 0 : this.getNumberOfShards().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityMode() == null ? 0 : this.getAvailabilityMode().hashCode());
        hashCode = 31 * hashCode + (this.getClusterEndpoint() == null ? 0 : this.getClusterEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEnginePatchVersion() == null ? 0 : this.getEnginePatchVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameterGroupName() == null ? 0 : this.getParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getParameterGroupStatus() == null ? 0 : this.getParameterGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroupName() == null ? 0 : this.getSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getTLSEnabled() == null ? 0 : this.getTLSEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getSnsTopicArn() == null ? 0 : this.getSnsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getSnsTopicStatus() == null ? 0 : this.getSnsTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceWindow() == null ? 0 : this.getMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getACLName() == null ? 0 : this.getACLName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

