/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.medialive.model.MultiplexSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMultiplexesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<MultiplexSummary> multiplexes;
    private String nextToken;

    public List<MultiplexSummary> getMultiplexes() {
        return this.multiplexes;
    }

    public void setMultiplexes(Collection<MultiplexSummary> multiplexes) {
        if (multiplexes == null) {
            this.multiplexes = null;
            return;
        }
        this.multiplexes = new ArrayList<MultiplexSummary>(multiplexes);
    }

    public ListMultiplexesResult withMultiplexes(MultiplexSummary ... multiplexes) {
        if (this.multiplexes == null) {
            this.setMultiplexes(new ArrayList<MultiplexSummary>(multiplexes.length));
        }
        for (MultiplexSummary ele : multiplexes) {
            this.multiplexes.add(ele);
        }
        return this;
    }

    public ListMultiplexesResult withMultiplexes(Collection<MultiplexSummary> multiplexes) {
        this.setMultiplexes(multiplexes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMultiplexesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMultiplexes() != null) {
            sb.append("Multiplexes: ").append(this.getMultiplexes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexesResult)) {
            return false;
        }
        ListMultiplexesResult other = (ListMultiplexesResult)obj;
        if (other.getMultiplexes() == null ^ this.getMultiplexes() == null) {
            return false;
        }
        if (other.getMultiplexes() != null && !other.getMultiplexes().equals(this.getMultiplexes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMultiplexes() == null ? 0 : this.getMultiplexes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMultiplexesResult clone() {
        try {
            return (ListMultiplexesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

