/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.AudioNormalizationAlgorithm;
import com.amazonaws.services.medialive.model.AudioNormalizationAlgorithmControl;
import com.amazonaws.services.medialive.model.transform.AudioNormalizationSettingsMarshaller;
import java.io.Serializable;

public class AudioNormalizationSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private String algorithmControl;
    private Double targetLkfs;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AudioNormalizationSettings withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public AudioNormalizationSettings withAlgorithm(AudioNormalizationAlgorithm algorithm) {
        this.algorithm = algorithm.toString();
        return this;
    }

    public void setAlgorithmControl(String algorithmControl) {
        this.algorithmControl = algorithmControl;
    }

    public String getAlgorithmControl() {
        return this.algorithmControl;
    }

    public AudioNormalizationSettings withAlgorithmControl(String algorithmControl) {
        this.setAlgorithmControl(algorithmControl);
        return this;
    }

    public AudioNormalizationSettings withAlgorithmControl(AudioNormalizationAlgorithmControl algorithmControl) {
        this.algorithmControl = algorithmControl.toString();
        return this;
    }

    public void setTargetLkfs(Double targetLkfs) {
        this.targetLkfs = targetLkfs;
    }

    public Double getTargetLkfs() {
        return this.targetLkfs;
    }

    public AudioNormalizationSettings withTargetLkfs(Double targetLkfs) {
        this.setTargetLkfs(targetLkfs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getAlgorithmControl() != null) {
            sb.append("AlgorithmControl: ").append(this.getAlgorithmControl()).append(",");
        }
        if (this.getTargetLkfs() != null) {
            sb.append("TargetLkfs: ").append(this.getTargetLkfs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioNormalizationSettings)) {
            return false;
        }
        AudioNormalizationSettings other = (AudioNormalizationSettings)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getAlgorithmControl() == null ^ this.getAlgorithmControl() == null) {
            return false;
        }
        if (other.getAlgorithmControl() != null && !other.getAlgorithmControl().equals(this.getAlgorithmControl())) {
            return false;
        }
        if (other.getTargetLkfs() == null ^ this.getTargetLkfs() == null) {
            return false;
        }
        return other.getTargetLkfs() == null || other.getTargetLkfs().equals(this.getTargetLkfs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmControl() == null ? 0 : this.getAlgorithmControl().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLkfs() == null ? 0 : this.getTargetLkfs().hashCode());
        return hashCode;
    }

    public AudioNormalizationSettings clone() {
        try {
            return (AudioNormalizationSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioNormalizationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

