/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.AudioSelector;
import com.amazonaws.services.medialive.model.CaptionSelector;
import com.amazonaws.services.medialive.model.InputDeblockFilter;
import com.amazonaws.services.medialive.model.InputDenoiseFilter;
import com.amazonaws.services.medialive.model.InputFilter;
import com.amazonaws.services.medialive.model.InputSourceEndBehavior;
import com.amazonaws.services.medialive.model.NetworkInputSettings;
import com.amazonaws.services.medialive.model.Smpte2038DataPreference;
import com.amazonaws.services.medialive.model.VideoSelector;
import com.amazonaws.services.medialive.model.transform.InputSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AudioSelector> audioSelectors;
    private List<CaptionSelector> captionSelectors;
    private String deblockFilter;
    private String denoiseFilter;
    private Integer filterStrength;
    private String inputFilter;
    private NetworkInputSettings networkInputSettings;
    private String smpte2038DataPreference;
    private String sourceEndBehavior;
    private VideoSelector videoSelector;

    public List<AudioSelector> getAudioSelectors() {
        return this.audioSelectors;
    }

    public void setAudioSelectors(Collection<AudioSelector> audioSelectors) {
        if (audioSelectors == null) {
            this.audioSelectors = null;
            return;
        }
        this.audioSelectors = new ArrayList<AudioSelector>(audioSelectors);
    }

    public InputSettings withAudioSelectors(AudioSelector ... audioSelectors) {
        if (this.audioSelectors == null) {
            this.setAudioSelectors(new ArrayList<AudioSelector>(audioSelectors.length));
        }
        for (AudioSelector ele : audioSelectors) {
            this.audioSelectors.add(ele);
        }
        return this;
    }

    public InputSettings withAudioSelectors(Collection<AudioSelector> audioSelectors) {
        this.setAudioSelectors(audioSelectors);
        return this;
    }

    public List<CaptionSelector> getCaptionSelectors() {
        return this.captionSelectors;
    }

    public void setCaptionSelectors(Collection<CaptionSelector> captionSelectors) {
        if (captionSelectors == null) {
            this.captionSelectors = null;
            return;
        }
        this.captionSelectors = new ArrayList<CaptionSelector>(captionSelectors);
    }

    public InputSettings withCaptionSelectors(CaptionSelector ... captionSelectors) {
        if (this.captionSelectors == null) {
            this.setCaptionSelectors(new ArrayList<CaptionSelector>(captionSelectors.length));
        }
        for (CaptionSelector ele : captionSelectors) {
            this.captionSelectors.add(ele);
        }
        return this;
    }

    public InputSettings withCaptionSelectors(Collection<CaptionSelector> captionSelectors) {
        this.setCaptionSelectors(captionSelectors);
        return this;
    }

    public void setDeblockFilter(String deblockFilter) {
        this.deblockFilter = deblockFilter;
    }

    public String getDeblockFilter() {
        return this.deblockFilter;
    }

    public InputSettings withDeblockFilter(String deblockFilter) {
        this.setDeblockFilter(deblockFilter);
        return this;
    }

    public InputSettings withDeblockFilter(InputDeblockFilter deblockFilter) {
        this.deblockFilter = deblockFilter.toString();
        return this;
    }

    public void setDenoiseFilter(String denoiseFilter) {
        this.denoiseFilter = denoiseFilter;
    }

    public String getDenoiseFilter() {
        return this.denoiseFilter;
    }

    public InputSettings withDenoiseFilter(String denoiseFilter) {
        this.setDenoiseFilter(denoiseFilter);
        return this;
    }

    public InputSettings withDenoiseFilter(InputDenoiseFilter denoiseFilter) {
        this.denoiseFilter = denoiseFilter.toString();
        return this;
    }

    public void setFilterStrength(Integer filterStrength) {
        this.filterStrength = filterStrength;
    }

    public Integer getFilterStrength() {
        return this.filterStrength;
    }

    public InputSettings withFilterStrength(Integer filterStrength) {
        this.setFilterStrength(filterStrength);
        return this;
    }

    public void setInputFilter(String inputFilter) {
        this.inputFilter = inputFilter;
    }

    public String getInputFilter() {
        return this.inputFilter;
    }

    public InputSettings withInputFilter(String inputFilter) {
        this.setInputFilter(inputFilter);
        return this;
    }

    public InputSettings withInputFilter(InputFilter inputFilter) {
        this.inputFilter = inputFilter.toString();
        return this;
    }

    public void setNetworkInputSettings(NetworkInputSettings networkInputSettings) {
        this.networkInputSettings = networkInputSettings;
    }

    public NetworkInputSettings getNetworkInputSettings() {
        return this.networkInputSettings;
    }

    public InputSettings withNetworkInputSettings(NetworkInputSettings networkInputSettings) {
        this.setNetworkInputSettings(networkInputSettings);
        return this;
    }

    public void setSmpte2038DataPreference(String smpte2038DataPreference) {
        this.smpte2038DataPreference = smpte2038DataPreference;
    }

    public String getSmpte2038DataPreference() {
        return this.smpte2038DataPreference;
    }

    public InputSettings withSmpte2038DataPreference(String smpte2038DataPreference) {
        this.setSmpte2038DataPreference(smpte2038DataPreference);
        return this;
    }

    public InputSettings withSmpte2038DataPreference(Smpte2038DataPreference smpte2038DataPreference) {
        this.smpte2038DataPreference = smpte2038DataPreference.toString();
        return this;
    }

    public void setSourceEndBehavior(String sourceEndBehavior) {
        this.sourceEndBehavior = sourceEndBehavior;
    }

    public String getSourceEndBehavior() {
        return this.sourceEndBehavior;
    }

    public InputSettings withSourceEndBehavior(String sourceEndBehavior) {
        this.setSourceEndBehavior(sourceEndBehavior);
        return this;
    }

    public InputSettings withSourceEndBehavior(InputSourceEndBehavior sourceEndBehavior) {
        this.sourceEndBehavior = sourceEndBehavior.toString();
        return this;
    }

    public void setVideoSelector(VideoSelector videoSelector) {
        this.videoSelector = videoSelector;
    }

    public VideoSelector getVideoSelector() {
        return this.videoSelector;
    }

    public InputSettings withVideoSelector(VideoSelector videoSelector) {
        this.setVideoSelector(videoSelector);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudioSelectors() != null) {
            sb.append("AudioSelectors: ").append(this.getAudioSelectors()).append(",");
        }
        if (this.getCaptionSelectors() != null) {
            sb.append("CaptionSelectors: ").append(this.getCaptionSelectors()).append(",");
        }
        if (this.getDeblockFilter() != null) {
            sb.append("DeblockFilter: ").append(this.getDeblockFilter()).append(",");
        }
        if (this.getDenoiseFilter() != null) {
            sb.append("DenoiseFilter: ").append(this.getDenoiseFilter()).append(",");
        }
        if (this.getFilterStrength() != null) {
            sb.append("FilterStrength: ").append(this.getFilterStrength()).append(",");
        }
        if (this.getInputFilter() != null) {
            sb.append("InputFilter: ").append(this.getInputFilter()).append(",");
        }
        if (this.getNetworkInputSettings() != null) {
            sb.append("NetworkInputSettings: ").append(this.getNetworkInputSettings()).append(",");
        }
        if (this.getSmpte2038DataPreference() != null) {
            sb.append("Smpte2038DataPreference: ").append(this.getSmpte2038DataPreference()).append(",");
        }
        if (this.getSourceEndBehavior() != null) {
            sb.append("SourceEndBehavior: ").append(this.getSourceEndBehavior()).append(",");
        }
        if (this.getVideoSelector() != null) {
            sb.append("VideoSelector: ").append(this.getVideoSelector());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSettings)) {
            return false;
        }
        InputSettings other = (InputSettings)obj;
        if (other.getAudioSelectors() == null ^ this.getAudioSelectors() == null) {
            return false;
        }
        if (other.getAudioSelectors() != null && !other.getAudioSelectors().equals(this.getAudioSelectors())) {
            return false;
        }
        if (other.getCaptionSelectors() == null ^ this.getCaptionSelectors() == null) {
            return false;
        }
        if (other.getCaptionSelectors() != null && !other.getCaptionSelectors().equals(this.getCaptionSelectors())) {
            return false;
        }
        if (other.getDeblockFilter() == null ^ this.getDeblockFilter() == null) {
            return false;
        }
        if (other.getDeblockFilter() != null && !other.getDeblockFilter().equals(this.getDeblockFilter())) {
            return false;
        }
        if (other.getDenoiseFilter() == null ^ this.getDenoiseFilter() == null) {
            return false;
        }
        if (other.getDenoiseFilter() != null && !other.getDenoiseFilter().equals(this.getDenoiseFilter())) {
            return false;
        }
        if (other.getFilterStrength() == null ^ this.getFilterStrength() == null) {
            return false;
        }
        if (other.getFilterStrength() != null && !other.getFilterStrength().equals(this.getFilterStrength())) {
            return false;
        }
        if (other.getInputFilter() == null ^ this.getInputFilter() == null) {
            return false;
        }
        if (other.getInputFilter() != null && !other.getInputFilter().equals(this.getInputFilter())) {
            return false;
        }
        if (other.getNetworkInputSettings() == null ^ this.getNetworkInputSettings() == null) {
            return false;
        }
        if (other.getNetworkInputSettings() != null && !other.getNetworkInputSettings().equals(this.getNetworkInputSettings())) {
            return false;
        }
        if (other.getSmpte2038DataPreference() == null ^ this.getSmpte2038DataPreference() == null) {
            return false;
        }
        if (other.getSmpte2038DataPreference() != null && !other.getSmpte2038DataPreference().equals(this.getSmpte2038DataPreference())) {
            return false;
        }
        if (other.getSourceEndBehavior() == null ^ this.getSourceEndBehavior() == null) {
            return false;
        }
        if (other.getSourceEndBehavior() != null && !other.getSourceEndBehavior().equals(this.getSourceEndBehavior())) {
            return false;
        }
        if (other.getVideoSelector() == null ^ this.getVideoSelector() == null) {
            return false;
        }
        return other.getVideoSelector() == null || other.getVideoSelector().equals(this.getVideoSelector());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudioSelectors() == null ? 0 : this.getAudioSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionSelectors() == null ? 0 : this.getCaptionSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getDeblockFilter() == null ? 0 : this.getDeblockFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDenoiseFilter() == null ? 0 : this.getDenoiseFilter().hashCode());
        hashCode = 31 * hashCode + (this.getFilterStrength() == null ? 0 : this.getFilterStrength().hashCode());
        hashCode = 31 * hashCode + (this.getInputFilter() == null ? 0 : this.getInputFilter().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInputSettings() == null ? 0 : this.getNetworkInputSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSmpte2038DataPreference() == null ? 0 : this.getSmpte2038DataPreference().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEndBehavior() == null ? 0 : this.getSourceEndBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getVideoSelector() == null ? 0 : this.getVideoSelector().hashCode());
        return hashCode;
    }

    public InputSettings clone() {
        try {
            return (InputSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

