/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.medialive.AWSMediaLive;
import com.amazonaws.services.medialive.AWSMediaLiveClientBuilder;
import com.amazonaws.services.medialive.model.AWSMediaLiveException;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleRequest;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleResult;
import com.amazonaws.services.medialive.model.CreateChannelRequest;
import com.amazonaws.services.medialive.model.CreateChannelResult;
import com.amazonaws.services.medialive.model.CreateInputRequest;
import com.amazonaws.services.medialive.model.CreateInputResult;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.CreateMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.CreateMultiplexProgramResult;
import com.amazonaws.services.medialive.model.CreateMultiplexRequest;
import com.amazonaws.services.medialive.model.CreateMultiplexResult;
import com.amazonaws.services.medialive.model.CreateTagsRequest;
import com.amazonaws.services.medialive.model.CreateTagsResult;
import com.amazonaws.services.medialive.model.DeleteChannelRequest;
import com.amazonaws.services.medialive.model.DeleteChannelResult;
import com.amazonaws.services.medialive.model.DeleteInputRequest;
import com.amazonaws.services.medialive.model.DeleteInputResult;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DeleteMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.DeleteMultiplexProgramResult;
import com.amazonaws.services.medialive.model.DeleteMultiplexRequest;
import com.amazonaws.services.medialive.model.DeleteMultiplexResult;
import com.amazonaws.services.medialive.model.DeleteReservationRequest;
import com.amazonaws.services.medialive.model.DeleteReservationResult;
import com.amazonaws.services.medialive.model.DeleteScheduleRequest;
import com.amazonaws.services.medialive.model.DeleteScheduleResult;
import com.amazonaws.services.medialive.model.DeleteTagsRequest;
import com.amazonaws.services.medialive.model.DeleteTagsResult;
import com.amazonaws.services.medialive.model.DescribeChannelRequest;
import com.amazonaws.services.medialive.model.DescribeChannelResult;
import com.amazonaws.services.medialive.model.DescribeInputDeviceRequest;
import com.amazonaws.services.medialive.model.DescribeInputDeviceResult;
import com.amazonaws.services.medialive.model.DescribeInputRequest;
import com.amazonaws.services.medialive.model.DescribeInputResult;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DescribeMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.DescribeMultiplexProgramResult;
import com.amazonaws.services.medialive.model.DescribeMultiplexRequest;
import com.amazonaws.services.medialive.model.DescribeMultiplexResult;
import com.amazonaws.services.medialive.model.DescribeOfferingRequest;
import com.amazonaws.services.medialive.model.DescribeOfferingResult;
import com.amazonaws.services.medialive.model.DescribeReservationRequest;
import com.amazonaws.services.medialive.model.DescribeReservationResult;
import com.amazonaws.services.medialive.model.DescribeScheduleRequest;
import com.amazonaws.services.medialive.model.DescribeScheduleResult;
import com.amazonaws.services.medialive.model.ListChannelsRequest;
import com.amazonaws.services.medialive.model.ListChannelsResult;
import com.amazonaws.services.medialive.model.ListInputDevicesRequest;
import com.amazonaws.services.medialive.model.ListInputDevicesResult;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsRequest;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsResult;
import com.amazonaws.services.medialive.model.ListInputsRequest;
import com.amazonaws.services.medialive.model.ListInputsResult;
import com.amazonaws.services.medialive.model.ListMultiplexProgramsRequest;
import com.amazonaws.services.medialive.model.ListMultiplexProgramsResult;
import com.amazonaws.services.medialive.model.ListMultiplexesRequest;
import com.amazonaws.services.medialive.model.ListMultiplexesResult;
import com.amazonaws.services.medialive.model.ListOfferingsRequest;
import com.amazonaws.services.medialive.model.ListOfferingsResult;
import com.amazonaws.services.medialive.model.ListReservationsRequest;
import com.amazonaws.services.medialive.model.ListReservationsResult;
import com.amazonaws.services.medialive.model.ListTagsForResourceRequest;
import com.amazonaws.services.medialive.model.ListTagsForResourceResult;
import com.amazonaws.services.medialive.model.PurchaseOfferingRequest;
import com.amazonaws.services.medialive.model.PurchaseOfferingResult;
import com.amazonaws.services.medialive.model.StartChannelRequest;
import com.amazonaws.services.medialive.model.StartChannelResult;
import com.amazonaws.services.medialive.model.StartMultiplexRequest;
import com.amazonaws.services.medialive.model.StartMultiplexResult;
import com.amazonaws.services.medialive.model.StopChannelRequest;
import com.amazonaws.services.medialive.model.StopChannelResult;
import com.amazonaws.services.medialive.model.StopMultiplexRequest;
import com.amazonaws.services.medialive.model.StopMultiplexResult;
import com.amazonaws.services.medialive.model.UpdateChannelClassRequest;
import com.amazonaws.services.medialive.model.UpdateChannelClassResult;
import com.amazonaws.services.medialive.model.UpdateChannelRequest;
import com.amazonaws.services.medialive.model.UpdateChannelResult;
import com.amazonaws.services.medialive.model.UpdateInputDeviceRequest;
import com.amazonaws.services.medialive.model.UpdateInputDeviceResult;
import com.amazonaws.services.medialive.model.UpdateInputRequest;
import com.amazonaws.services.medialive.model.UpdateInputResult;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.UpdateMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.UpdateMultiplexProgramResult;
import com.amazonaws.services.medialive.model.UpdateMultiplexRequest;
import com.amazonaws.services.medialive.model.UpdateMultiplexResult;
import com.amazonaws.services.medialive.model.UpdateReservationRequest;
import com.amazonaws.services.medialive.model.UpdateReservationResult;
import com.amazonaws.services.medialive.model.transform.BadGatewayExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.BatchUpdateScheduleRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.BatchUpdateScheduleResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateMultiplexProgramRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateMultiplexProgramResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateTagsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateTagsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteMultiplexProgramRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteMultiplexProgramResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteReservationRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteReservationResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteScheduleRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteScheduleResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteTagsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputDeviceRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputDeviceResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeMultiplexProgramRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeMultiplexProgramResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeOfferingRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeOfferingResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeReservationRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeReservationResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeScheduleRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeScheduleResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.GatewayTimeoutExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputDevicesRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputDevicesResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputSecurityGroupsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListMultiplexProgramsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListMultiplexProgramsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListMultiplexesRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListMultiplexesResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListOfferingsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListOfferingsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListReservationsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListReservationsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.PurchaseOfferingRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.PurchaseOfferingResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StartChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StartChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StartMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StartMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StopChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StopChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StopMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StopMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UnprocessableEntityExceptionUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelClassRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelClassResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputDeviceRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputDeviceResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateMultiplexProgramRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateMultiplexProgramResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateMultiplexRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateMultiplexResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateReservationRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateReservationResultJsonUnmarshaller;
import com.amazonaws.services.medialive.waiters.AWSMediaLiveWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaLiveClient
extends AmazonWebServiceClient
implements AWSMediaLive {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaLive.class);
    private static final String DEFAULT_SIGNING_NAME = "medialive";
    private volatile AWSMediaLiveWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnprocessableEntityExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadGatewayExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GatewayTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)GatewayTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaLiveException.class));

    public static AWSMediaLiveClientBuilder builder() {
        return AWSMediaLiveClientBuilder.standard();
    }

    AWSMediaLiveClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaLiveClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("medialive.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/medialive/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/medialive/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchUpdateScheduleResult batchUpdateSchedule(BatchUpdateScheduleRequest request) {
        request = (BatchUpdateScheduleRequest)this.beforeClientExecution(request);
        return this.executeBatchUpdateSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateScheduleResult executeBatchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateScheduleRequestProtocolMarshaller(protocolFactory).marshall((BatchUpdateScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUpdateScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUpdateSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUpdateScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpdateScheduleResult batchUpdateScheduleResult = (BatchUpdateScheduleResult)response.getAwsResponse();
            return batchUpdateScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInputResult createInput(CreateInputRequest request) {
        request = (CreateInputRequest)this.beforeClientExecution(request);
        return this.executeCreateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInputResult executeCreateInput(CreateInputRequest createInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInputRequestProtocolMarshaller(protocolFactory).marshall((CreateInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)createInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInputResult createInputResult = (CreateInputResult)response.getAwsResponse();
            return createInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInputSecurityGroupResult createInputSecurityGroup(CreateInputSecurityGroupRequest request) {
        request = (CreateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInputSecurityGroupResult executeCreateInputSecurityGroup(CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateInputSecurityGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateInputSecurityGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInputSecurityGroupResult createInputSecurityGroupResult = (CreateInputSecurityGroupResult)response.getAwsResponse();
            return createInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMultiplexResult createMultiplex(CreateMultiplexRequest request) {
        request = (CreateMultiplexRequest)this.beforeClientExecution(request);
        return this.executeCreateMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMultiplexResult executeCreateMultiplex(CreateMultiplexRequest createMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMultiplexRequestProtocolMarshaller(protocolFactory).marshall((CreateMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMultiplexResult createMultiplexResult = (CreateMultiplexResult)response.getAwsResponse();
            return createMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMultiplexProgramResult createMultiplexProgram(CreateMultiplexProgramRequest request) {
        request = (CreateMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executeCreateMultiplexProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMultiplexProgramResult executeCreateMultiplexProgram(CreateMultiplexProgramRequest createMultiplexProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMultiplexProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMultiplexProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMultiplexProgramRequestProtocolMarshaller(protocolFactory).marshall((CreateMultiplexProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMultiplexProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMultiplexProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMultiplexProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMultiplexProgramResult createMultiplexProgramResult = (CreateMultiplexProgramResult)response.getAwsResponse();
            return createMultiplexProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTagsResult createTags(CreateTagsRequest request) {
        request = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executeCreateTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTagsResult executeCreateTags(CreateTagsRequest createTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTagsRequestProtocolMarshaller(protocolFactory).marshall((CreateTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTagsResult createTagsResult = (CreateTagsResult)response.getAwsResponse();
            return createTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInputResult deleteInput(DeleteInputRequest request) {
        request = (DeleteInputRequest)this.beforeClientExecution(request);
        return this.executeDeleteInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInputResult executeDeleteInput(DeleteInputRequest deleteInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInputRequestProtocolMarshaller(protocolFactory).marshall((DeleteInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInputResult deleteInputResult = (DeleteInputResult)response.getAwsResponse();
            return deleteInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInputSecurityGroupResult deleteInputSecurityGroup(DeleteInputSecurityGroupRequest request) {
        request = (DeleteInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInputSecurityGroupResult executeDeleteInputSecurityGroup(DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteInputSecurityGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInputSecurityGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInputSecurityGroupResult deleteInputSecurityGroupResult = (DeleteInputSecurityGroupResult)response.getAwsResponse();
            return deleteInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMultiplexResult deleteMultiplex(DeleteMultiplexRequest request) {
        request = (DeleteMultiplexRequest)this.beforeClientExecution(request);
        return this.executeDeleteMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMultiplexResult executeDeleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMultiplexRequestProtocolMarshaller(protocolFactory).marshall((DeleteMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMultiplexResult deleteMultiplexResult = (DeleteMultiplexResult)response.getAwsResponse();
            return deleteMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMultiplexProgramResult deleteMultiplexProgram(DeleteMultiplexProgramRequest request) {
        request = (DeleteMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executeDeleteMultiplexProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMultiplexProgramResult executeDeleteMultiplexProgram(DeleteMultiplexProgramRequest deleteMultiplexProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMultiplexProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMultiplexProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMultiplexProgramRequestProtocolMarshaller(protocolFactory).marshall((DeleteMultiplexProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMultiplexProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMultiplexProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMultiplexProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMultiplexProgramResult deleteMultiplexProgramResult = (DeleteMultiplexProgramResult)response.getAwsResponse();
            return deleteMultiplexProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteReservationResult deleteReservation(DeleteReservationRequest request) {
        request = (DeleteReservationRequest)this.beforeClientExecution(request);
        return this.executeDeleteReservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReservationResult executeDeleteReservation(DeleteReservationRequest deleteReservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReservationRequestProtocolMarshaller(protocolFactory).marshall((DeleteReservationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteReservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteReservation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteReservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReservationResult deleteReservationResult = (DeleteReservationResult)response.getAwsResponse();
            return deleteReservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteScheduleResult deleteSchedule(DeleteScheduleRequest request) {
        request = (DeleteScheduleRequest)this.beforeClientExecution(request);
        return this.executeDeleteSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteScheduleResult executeDeleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScheduleRequestProtocolMarshaller(protocolFactory).marshall((DeleteScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteScheduleResult deleteScheduleResult = (DeleteScheduleResult)response.getAwsResponse();
            return deleteScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        request = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executeDeleteTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTagsResult executeDeleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestProtocolMarshaller(protocolFactory).marshall((DeleteTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        request = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executeDescribeChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChannelResult executeDescribeChannel(DescribeChannelRequest describeChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChannelRequestProtocolMarshaller(protocolFactory).marshall((DescribeChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChannelResult describeChannelResult = (DescribeChannelResult)response.getAwsResponse();
            return describeChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputResult describeInput(DescribeInputRequest request) {
        request = (DescribeInputRequest)this.beforeClientExecution(request);
        return this.executeDescribeInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputResult executeDescribeInput(DescribeInputRequest describeInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputRequestProtocolMarshaller(protocolFactory).marshall((DescribeInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputResult describeInputResult = (DescribeInputResult)response.getAwsResponse();
            return describeInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputDeviceResult describeInputDevice(DescribeInputDeviceRequest request) {
        request = (DescribeInputDeviceRequest)this.beforeClientExecution(request);
        return this.executeDescribeInputDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputDeviceResult executeDescribeInputDevice(DescribeInputDeviceRequest describeInputDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputDeviceRequestProtocolMarshaller(protocolFactory).marshall((DescribeInputDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInputDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInputDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputDeviceResult describeInputDeviceResult = (DescribeInputDeviceResult)response.getAwsResponse();
            return describeInputDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputSecurityGroupResult describeInputSecurityGroup(DescribeInputSecurityGroupRequest request) {
        request = (DescribeInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputSecurityGroupResult executeDescribeInputSecurityGroup(DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeInputSecurityGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInputSecurityGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputSecurityGroupResult describeInputSecurityGroupResult = (DescribeInputSecurityGroupResult)response.getAwsResponse();
            return describeInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMultiplexResult describeMultiplex(DescribeMultiplexRequest request) {
        request = (DescribeMultiplexRequest)this.beforeClientExecution(request);
        return this.executeDescribeMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMultiplexResult executeDescribeMultiplex(DescribeMultiplexRequest describeMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMultiplexRequestProtocolMarshaller(protocolFactory).marshall((DescribeMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMultiplexResult describeMultiplexResult = (DescribeMultiplexResult)response.getAwsResponse();
            return describeMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMultiplexProgramResult describeMultiplexProgram(DescribeMultiplexProgramRequest request) {
        request = (DescribeMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executeDescribeMultiplexProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMultiplexProgramResult executeDescribeMultiplexProgram(DescribeMultiplexProgramRequest describeMultiplexProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMultiplexProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMultiplexProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMultiplexProgramRequestProtocolMarshaller(protocolFactory).marshall((DescribeMultiplexProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMultiplexProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeMultiplexProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMultiplexProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMultiplexProgramResult describeMultiplexProgramResult = (DescribeMultiplexProgramResult)response.getAwsResponse();
            return describeMultiplexProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOfferingResult describeOffering(DescribeOfferingRequest request) {
        request = (DescribeOfferingRequest)this.beforeClientExecution(request);
        return this.executeDescribeOffering(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOfferingResult executeDescribeOffering(DescribeOfferingRequest describeOfferingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOfferingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOfferingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOfferingRequestProtocolMarshaller(protocolFactory).marshall((DescribeOfferingRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOfferingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOffering");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOfferingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOfferingResult describeOfferingResult = (DescribeOfferingResult)response.getAwsResponse();
            return describeOfferingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeReservationResult describeReservation(DescribeReservationRequest request) {
        request = (DescribeReservationRequest)this.beforeClientExecution(request);
        return this.executeDescribeReservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeReservationResult executeDescribeReservation(DescribeReservationRequest describeReservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeReservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeReservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeReservationRequestProtocolMarshaller(protocolFactory).marshall((DescribeReservationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeReservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeReservation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeReservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeReservationResult describeReservationResult = (DescribeReservationResult)response.getAwsResponse();
            return describeReservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScheduleResult describeSchedule(DescribeScheduleRequest request) {
        request = (DescribeScheduleRequest)this.beforeClientExecution(request);
        return this.executeDescribeSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScheduleResult executeDescribeSchedule(DescribeScheduleRequest describeScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScheduleRequestProtocolMarshaller(protocolFactory).marshall((DescribeScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeScheduleResult describeScheduleResult = (DescribeScheduleResult)response.getAwsResponse();
            return describeScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputDevicesResult listInputDevices(ListInputDevicesRequest request) {
        request = (ListInputDevicesRequest)this.beforeClientExecution(request);
        return this.executeListInputDevices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputDevicesResult executeListInputDevices(ListInputDevicesRequest listInputDevicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputDevicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputDevicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputDevicesRequestProtocolMarshaller(protocolFactory).marshall((ListInputDevicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInputDevicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInputDevices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputDevicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputDevicesResult listInputDevicesResult = (ListInputDevicesResult)response.getAwsResponse();
            return listInputDevicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputSecurityGroupsResult listInputSecurityGroups(ListInputSecurityGroupsRequest request) {
        request = (ListInputSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executeListInputSecurityGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputSecurityGroupsResult executeListInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputSecurityGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListInputSecurityGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInputSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInputSecurityGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputSecurityGroupsResult listInputSecurityGroupsResult = (ListInputSecurityGroupsResult)response.getAwsResponse();
            return listInputSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputsResult listInputs(ListInputsRequest request) {
        request = (ListInputsRequest)this.beforeClientExecution(request);
        return this.executeListInputs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputsResult executeListInputs(ListInputsRequest listInputsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputsRequestProtocolMarshaller(protocolFactory).marshall((ListInputsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInputsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInputs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputsResult listInputsResult = (ListInputsResult)response.getAwsResponse();
            return listInputsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMultiplexProgramsResult listMultiplexPrograms(ListMultiplexProgramsRequest request) {
        request = (ListMultiplexProgramsRequest)this.beforeClientExecution(request);
        return this.executeListMultiplexPrograms(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMultiplexProgramsResult executeListMultiplexPrograms(ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMultiplexProgramsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMultiplexProgramsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMultiplexProgramsRequestProtocolMarshaller(protocolFactory).marshall((ListMultiplexProgramsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMultiplexProgramsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMultiplexPrograms");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMultiplexProgramsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMultiplexProgramsResult listMultiplexProgramsResult = (ListMultiplexProgramsResult)response.getAwsResponse();
            return listMultiplexProgramsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMultiplexesResult listMultiplexes(ListMultiplexesRequest request) {
        request = (ListMultiplexesRequest)this.beforeClientExecution(request);
        return this.executeListMultiplexes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMultiplexesResult executeListMultiplexes(ListMultiplexesRequest listMultiplexesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMultiplexesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMultiplexesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMultiplexesRequestProtocolMarshaller(protocolFactory).marshall((ListMultiplexesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMultiplexesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMultiplexes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMultiplexesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMultiplexesResult listMultiplexesResult = (ListMultiplexesResult)response.getAwsResponse();
            return listMultiplexesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOfferingsResult listOfferings(ListOfferingsRequest request) {
        request = (ListOfferingsRequest)this.beforeClientExecution(request);
        return this.executeListOfferings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOfferingsResult executeListOfferings(ListOfferingsRequest listOfferingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOfferingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOfferingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOfferingsRequestProtocolMarshaller(protocolFactory).marshall((ListOfferingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOfferingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOfferings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOfferingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOfferingsResult listOfferingsResult = (ListOfferingsResult)response.getAwsResponse();
            return listOfferingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReservationsResult listReservations(ListReservationsRequest request) {
        request = (ListReservationsRequest)this.beforeClientExecution(request);
        return this.executeListReservations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReservationsResult executeListReservations(ListReservationsRequest listReservationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReservationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReservationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReservationsRequestProtocolMarshaller(protocolFactory).marshall((ListReservationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReservationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReservations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReservationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReservationsResult listReservationsResult = (ListReservationsResult)response.getAwsResponse();
            return listReservationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PurchaseOfferingResult purchaseOffering(PurchaseOfferingRequest request) {
        request = (PurchaseOfferingRequest)this.beforeClientExecution(request);
        return this.executePurchaseOffering(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PurchaseOfferingResult executePurchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(purchaseOfferingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PurchaseOfferingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PurchaseOfferingRequestProtocolMarshaller(protocolFactory).marshall((PurchaseOfferingRequest)super.beforeMarshalling((AmazonWebServiceRequest)purchaseOfferingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PurchaseOffering");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PurchaseOfferingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PurchaseOfferingResult purchaseOfferingResult = (PurchaseOfferingResult)response.getAwsResponse();
            return purchaseOfferingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartChannelResult startChannel(StartChannelRequest request) {
        request = (StartChannelRequest)this.beforeClientExecution(request);
        return this.executeStartChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartChannelResult executeStartChannel(StartChannelRequest startChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartChannelRequestProtocolMarshaller(protocolFactory).marshall((StartChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)startChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartChannelResult startChannelResult = (StartChannelResult)response.getAwsResponse();
            return startChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartMultiplexResult startMultiplex(StartMultiplexRequest request) {
        request = (StartMultiplexRequest)this.beforeClientExecution(request);
        return this.executeStartMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMultiplexResult executeStartMultiplex(StartMultiplexRequest startMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMultiplexRequestProtocolMarshaller(protocolFactory).marshall((StartMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMultiplexResult startMultiplexResult = (StartMultiplexResult)response.getAwsResponse();
            return startMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopChannelResult stopChannel(StopChannelRequest request) {
        request = (StopChannelRequest)this.beforeClientExecution(request);
        return this.executeStopChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopChannelResult executeStopChannel(StopChannelRequest stopChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopChannelRequestProtocolMarshaller(protocolFactory).marshall((StopChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopChannelResult stopChannelResult = (StopChannelResult)response.getAwsResponse();
            return stopChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopMultiplexResult stopMultiplex(StopMultiplexRequest request) {
        request = (StopMultiplexRequest)this.beforeClientExecution(request);
        return this.executeStopMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopMultiplexResult executeStopMultiplex(StopMultiplexRequest stopMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopMultiplexRequestProtocolMarshaller(protocolFactory).marshall((StopMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopMultiplexResult stopMultiplexResult = (StopMultiplexResult)response.getAwsResponse();
            return stopMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelClassResult updateChannelClass(UpdateChannelClassRequest request) {
        request = (UpdateChannelClassRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannelClass(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelClassResult executeUpdateChannelClass(UpdateChannelClassRequest updateChannelClassRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelClassRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelClassRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelClassRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelClassRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelClassRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannelClass");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelClassResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelClassResult updateChannelClassResult = (UpdateChannelClassResult)response.getAwsResponse();
            return updateChannelClassResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputResult updateInput(UpdateInputRequest request) {
        request = (UpdateInputRequest)this.beforeClientExecution(request);
        return this.executeUpdateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputResult executeUpdateInput(UpdateInputRequest updateInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputRequestProtocolMarshaller(protocolFactory).marshall((UpdateInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputResult updateInputResult = (UpdateInputResult)response.getAwsResponse();
            return updateInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputDeviceResult updateInputDevice(UpdateInputDeviceRequest request) {
        request = (UpdateInputDeviceRequest)this.beforeClientExecution(request);
        return this.executeUpdateInputDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputDeviceResult executeUpdateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputDeviceRequestProtocolMarshaller(protocolFactory).marshall((UpdateInputDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInputDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInputDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInputDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputDeviceResult updateInputDeviceResult = (UpdateInputDeviceResult)response.getAwsResponse();
            return updateInputDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputSecurityGroupResult updateInputSecurityGroup(UpdateInputSecurityGroupRequest request) {
        request = (UpdateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputSecurityGroupResult executeUpdateInputSecurityGroup(UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateInputSecurityGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInputSecurityGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputSecurityGroupResult updateInputSecurityGroupResult = (UpdateInputSecurityGroupResult)response.getAwsResponse();
            return updateInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMultiplexResult updateMultiplex(UpdateMultiplexRequest request) {
        request = (UpdateMultiplexRequest)this.beforeClientExecution(request);
        return this.executeUpdateMultiplex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMultiplexResult executeUpdateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMultiplexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMultiplexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMultiplexRequestProtocolMarshaller(protocolFactory).marshall((UpdateMultiplexRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMultiplexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMultiplex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMultiplexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMultiplexResult updateMultiplexResult = (UpdateMultiplexResult)response.getAwsResponse();
            return updateMultiplexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMultiplexProgramResult updateMultiplexProgram(UpdateMultiplexProgramRequest request) {
        request = (UpdateMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executeUpdateMultiplexProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMultiplexProgramResult executeUpdateMultiplexProgram(UpdateMultiplexProgramRequest updateMultiplexProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMultiplexProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMultiplexProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMultiplexProgramRequestProtocolMarshaller(protocolFactory).marshall((UpdateMultiplexProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMultiplexProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMultiplexProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMultiplexProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMultiplexProgramResult updateMultiplexProgramResult = (UpdateMultiplexProgramResult)response.getAwsResponse();
            return updateMultiplexProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReservationResult updateReservation(UpdateReservationRequest request) {
        request = (UpdateReservationRequest)this.beforeClientExecution(request);
        return this.executeUpdateReservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReservationResult executeUpdateReservation(UpdateReservationRequest updateReservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReservationRequestProtocolMarshaller(protocolFactory).marshall((UpdateReservationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateReservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateReservation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReservationResult updateReservationResult = (UpdateReservationResult)response.getAwsResponse();
            return updateReservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSMediaLiveWaiters waiters() {
        if (this.waiters == null) {
            AWSMediaLiveClient aWSMediaLiveClient = this;
            synchronized (aWSMediaLiveClient) {
                if (this.waiters == null) {
                    this.waiters = new AWSMediaLiveWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

