/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.medialive.AWSMediaLiveAsync;
import com.amazonaws.services.medialive.AWSMediaLiveAsyncClientBuilder;
import com.amazonaws.services.medialive.AWSMediaLiveClient;
import com.amazonaws.services.medialive.model.CreateChannelRequest;
import com.amazonaws.services.medialive.model.CreateChannelResult;
import com.amazonaws.services.medialive.model.CreateInputRequest;
import com.amazonaws.services.medialive.model.CreateInputResult;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DeleteChannelRequest;
import com.amazonaws.services.medialive.model.DeleteChannelResult;
import com.amazonaws.services.medialive.model.DeleteInputRequest;
import com.amazonaws.services.medialive.model.DeleteInputResult;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DescribeChannelRequest;
import com.amazonaws.services.medialive.model.DescribeChannelResult;
import com.amazonaws.services.medialive.model.DescribeInputRequest;
import com.amazonaws.services.medialive.model.DescribeInputResult;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.ListChannelsRequest;
import com.amazonaws.services.medialive.model.ListChannelsResult;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsRequest;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsResult;
import com.amazonaws.services.medialive.model.ListInputsRequest;
import com.amazonaws.services.medialive.model.ListInputsResult;
import com.amazonaws.services.medialive.model.StartChannelRequest;
import com.amazonaws.services.medialive.model.StartChannelResult;
import com.amazonaws.services.medialive.model.StopChannelRequest;
import com.amazonaws.services.medialive.model.StopChannelResult;
import com.amazonaws.services.medialive.model.UpdateChannelRequest;
import com.amazonaws.services.medialive.model.UpdateChannelResult;
import com.amazonaws.services.medialive.model.UpdateInputRequest;
import com.amazonaws.services.medialive.model.UpdateInputResult;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaLiveAsyncClient
extends AWSMediaLiveClient
implements AWSMediaLiveAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaLiveAsyncClientBuilder asyncBuilder() {
        return AWSMediaLiveAsyncClientBuilder.standard();
    }

    AWSMediaLiveAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request) {
        return this.createInputAsync(request, null);
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request, final AsyncHandler<CreateInputRequest, CreateInputResult> asyncHandler) {
        final CreateInputRequest finalRequest = (CreateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInputResult>(){

            @Override
            public CreateInputResult call() throws Exception {
                CreateInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInputSecurityGroupResult> createInputSecurityGroupAsync(CreateInputSecurityGroupRequest request) {
        return this.createInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<CreateInputSecurityGroupResult> createInputSecurityGroupAsync(CreateInputSecurityGroupRequest request, final AsyncHandler<CreateInputSecurityGroupRequest, CreateInputSecurityGroupResult> asyncHandler) {
        final CreateInputSecurityGroupRequest finalRequest = (CreateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInputSecurityGroupResult>(){

            @Override
            public CreateInputSecurityGroupResult call() throws Exception {
                CreateInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request) {
        return this.deleteInputAsync(request, null);
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request, final AsyncHandler<DeleteInputRequest, DeleteInputResult> asyncHandler) {
        final DeleteInputRequest finalRequest = (DeleteInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInputResult>(){

            @Override
            public DeleteInputResult call() throws Exception {
                DeleteInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInputSecurityGroupResult> deleteInputSecurityGroupAsync(DeleteInputSecurityGroupRequest request) {
        return this.deleteInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteInputSecurityGroupResult> deleteInputSecurityGroupAsync(DeleteInputSecurityGroupRequest request, final AsyncHandler<DeleteInputSecurityGroupRequest, DeleteInputSecurityGroupResult> asyncHandler) {
        final DeleteInputSecurityGroupRequest finalRequest = (DeleteInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInputSecurityGroupResult>(){

            @Override
            public DeleteInputSecurityGroupResult call() throws Exception {
                DeleteInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request) {
        return this.describeChannelAsync(request, null);
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request, final AsyncHandler<DescribeChannelRequest, DescribeChannelResult> asyncHandler) {
        final DescribeChannelRequest finalRequest = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChannelResult>(){

            @Override
            public DescribeChannelResult call() throws Exception {
                DescribeChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request) {
        return this.describeInputAsync(request, null);
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request, final AsyncHandler<DescribeInputRequest, DescribeInputResult> asyncHandler) {
        final DescribeInputRequest finalRequest = (DescribeInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputResult>(){

            @Override
            public DescribeInputResult call() throws Exception {
                DescribeInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputSecurityGroupResult> describeInputSecurityGroupAsync(DescribeInputSecurityGroupRequest request) {
        return this.describeInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DescribeInputSecurityGroupResult> describeInputSecurityGroupAsync(DescribeInputSecurityGroupRequest request, final AsyncHandler<DescribeInputSecurityGroupRequest, DescribeInputSecurityGroupResult> asyncHandler) {
        final DescribeInputSecurityGroupRequest finalRequest = (DescribeInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputSecurityGroupResult>(){

            @Override
            public DescribeInputSecurityGroupResult call() throws Exception {
                DescribeInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputSecurityGroupsResult> listInputSecurityGroupsAsync(ListInputSecurityGroupsRequest request) {
        return this.listInputSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<ListInputSecurityGroupsResult> listInputSecurityGroupsAsync(ListInputSecurityGroupsRequest request, final AsyncHandler<ListInputSecurityGroupsRequest, ListInputSecurityGroupsResult> asyncHandler) {
        final ListInputSecurityGroupsRequest finalRequest = (ListInputSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputSecurityGroupsResult>(){

            @Override
            public ListInputSecurityGroupsResult call() throws Exception {
                ListInputSecurityGroupsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request) {
        return this.listInputsAsync(request, null);
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request, final AsyncHandler<ListInputsRequest, ListInputsResult> asyncHandler) {
        final ListInputsRequest finalRequest = (ListInputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputsResult>(){

            @Override
            public ListInputsResult call() throws Exception {
                ListInputsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request) {
        return this.startChannelAsync(request, null);
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request, final AsyncHandler<StartChannelRequest, StartChannelResult> asyncHandler) {
        final StartChannelRequest finalRequest = (StartChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChannelResult>(){

            @Override
            public StartChannelResult call() throws Exception {
                StartChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStartChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request) {
        return this.stopChannelAsync(request, null);
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request, final AsyncHandler<StopChannelRequest, StopChannelResult> asyncHandler) {
        final StopChannelRequest finalRequest = (StopChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopChannelResult>(){

            @Override
            public StopChannelResult call() throws Exception {
                StopChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStopChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request) {
        return this.updateInputAsync(request, null);
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request, final AsyncHandler<UpdateInputRequest, UpdateInputResult> asyncHandler) {
        final UpdateInputRequest finalRequest = (UpdateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputResult>(){

            @Override
            public UpdateInputResult call() throws Exception {
                UpdateInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputSecurityGroupResult> updateInputSecurityGroupAsync(UpdateInputSecurityGroupRequest request) {
        return this.updateInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<UpdateInputSecurityGroupResult> updateInputSecurityGroupAsync(UpdateInputSecurityGroupRequest request, final AsyncHandler<UpdateInputSecurityGroupRequest, UpdateInputSecurityGroupResult> asyncHandler) {
        final UpdateInputSecurityGroupRequest finalRequest = (UpdateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputSecurityGroupResult>(){

            @Override
            public UpdateInputSecurityGroupResult call() throws Exception {
                UpdateInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

