/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import javax.annotation.Generated;

/**
 * Type of video codec
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum VideoCodec {

    AV1("AV1"),
    AVC_INTRA("AVC_INTRA"),
    FRAME_CAPTURE("FRAME_CAPTURE"),
    H_264("H_264"),
    H_265("H_265"),
    MPEG2("MPEG2"),
    PRORES("PRORES"),
    VC3("VC3"),
    VP8("VP8"),
    VP9("VP9"),
    XAVC("XAVC");

    private String value;

    private VideoCodec(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return VideoCodec corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static VideoCodec fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (VideoCodec enumEntry : VideoCodec.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
