/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediaconvert.AWSMediaConvert;
import com.amazonaws.services.mediaconvert.AWSMediaConvertClientBuilder;
import com.amazonaws.services.mediaconvert.model.AWSMediaConvertException;
import com.amazonaws.services.mediaconvert.model.AssociateCertificateRequest;
import com.amazonaws.services.mediaconvert.model.AssociateCertificateResult;
import com.amazonaws.services.mediaconvert.model.CancelJobRequest;
import com.amazonaws.services.mediaconvert.model.CancelJobResult;
import com.amazonaws.services.mediaconvert.model.CreateJobRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobResult;
import com.amazonaws.services.mediaconvert.model.CreateJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.CreatePresetRequest;
import com.amazonaws.services.mediaconvert.model.CreatePresetResult;
import com.amazonaws.services.mediaconvert.model.CreateQueueRequest;
import com.amazonaws.services.mediaconvert.model.CreateQueueResult;
import com.amazonaws.services.mediaconvert.model.DeleteJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.DeleteJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.DeletePresetRequest;
import com.amazonaws.services.mediaconvert.model.DeletePresetResult;
import com.amazonaws.services.mediaconvert.model.DeleteQueueRequest;
import com.amazonaws.services.mediaconvert.model.DeleteQueueResult;
import com.amazonaws.services.mediaconvert.model.DescribeEndpointsRequest;
import com.amazonaws.services.mediaconvert.model.DescribeEndpointsResult;
import com.amazonaws.services.mediaconvert.model.DisassociateCertificateRequest;
import com.amazonaws.services.mediaconvert.model.DisassociateCertificateResult;
import com.amazonaws.services.mediaconvert.model.GetJobRequest;
import com.amazonaws.services.mediaconvert.model.GetJobResult;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.GetPresetRequest;
import com.amazonaws.services.mediaconvert.model.GetPresetResult;
import com.amazonaws.services.mediaconvert.model.GetQueueRequest;
import com.amazonaws.services.mediaconvert.model.GetQueueResult;
import com.amazonaws.services.mediaconvert.model.ListJobTemplatesRequest;
import com.amazonaws.services.mediaconvert.model.ListJobTemplatesResult;
import com.amazonaws.services.mediaconvert.model.ListJobsRequest;
import com.amazonaws.services.mediaconvert.model.ListJobsResult;
import com.amazonaws.services.mediaconvert.model.ListPresetsRequest;
import com.amazonaws.services.mediaconvert.model.ListPresetsResult;
import com.amazonaws.services.mediaconvert.model.ListQueuesRequest;
import com.amazonaws.services.mediaconvert.model.ListQueuesResult;
import com.amazonaws.services.mediaconvert.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediaconvert.model.ListTagsForResourceResult;
import com.amazonaws.services.mediaconvert.model.TagResourceRequest;
import com.amazonaws.services.mediaconvert.model.TagResourceResult;
import com.amazonaws.services.mediaconvert.model.UntagResourceRequest;
import com.amazonaws.services.mediaconvert.model.UntagResourceResult;
import com.amazonaws.services.mediaconvert.model.UpdateJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.UpdateJobTemplateResult;
import com.amazonaws.services.mediaconvert.model.UpdatePresetRequest;
import com.amazonaws.services.mediaconvert.model.UpdatePresetResult;
import com.amazonaws.services.mediaconvert.model.UpdateQueueRequest;
import com.amazonaws.services.mediaconvert.model.UpdateQueueResult;
import com.amazonaws.services.mediaconvert.model.transform.AssociateCertificateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.AssociateCertificateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CancelJobRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateJobRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateJobTemplateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateJobTemplateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreatePresetRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreatePresetResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateQueueRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.CreateQueueResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeleteJobTemplateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeleteJobTemplateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeletePresetRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeletePresetResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeleteQueueRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DeleteQueueResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DescribeEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DescribeEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DisassociateCertificateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.DisassociateCertificateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetJobRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetJobResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetJobTemplateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetJobTemplateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetPresetRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetPresetResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetQueueRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.GetQueueResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListJobTemplatesRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListJobTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListJobsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListPresetsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListPresetsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListQueuesRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListQueuesResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdateJobTemplateRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdateJobTemplateResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdatePresetRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdatePresetResultJsonUnmarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdateQueueRequestProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.transform.UpdateQueueResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaConvertClient
extends AmazonWebServiceClient
implements AWSMediaConvert {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaConvert.class);
    private static final String DEFAULT_SIGNING_NAME = "mediaconvert";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaConvertException.class));

    public static AWSMediaConvertClientBuilder builder() {
        return AWSMediaConvertClientBuilder.standard();
    }

    AWSMediaConvertClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaConvertClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediaconvert.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediaconvert/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediaconvert/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateCertificateResult associateCertificate(AssociateCertificateRequest request) {
        request = (AssociateCertificateRequest)this.beforeClientExecution(request);
        return this.executeAssociateCertificate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateCertificateResult executeAssociateCertificate(AssociateCertificateRequest associateCertificateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateCertificateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateCertificateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateCertificateRequestProtocolMarshaller(protocolFactory).marshall((AssociateCertificateRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateCertificateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateCertificate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateCertificateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateCertificateResult associateCertificateResult = (AssociateCertificateResult)response.getAwsResponse();
            return associateCertificateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        request = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executeCancelJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJobResult executeCancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestProtocolMarshaller(protocolFactory).marshall((CancelJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestProtocolMarshaller(protocolFactory).marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobTemplateResult createJobTemplate(CreateJobTemplateRequest request) {
        request = (CreateJobTemplateRequest)this.beforeClientExecution(request);
        return this.executeCreateJobTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobTemplateResult executeCreateJobTemplate(CreateJobTemplateRequest createJobTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobTemplateRequestProtocolMarshaller(protocolFactory).marshall((CreateJobTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJobTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobTemplateResult createJobTemplateResult = (CreateJobTemplateResult)response.getAwsResponse();
            return createJobTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePresetResult createPreset(CreatePresetRequest request) {
        request = (CreatePresetRequest)this.beforeClientExecution(request);
        return this.executeCreatePreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePresetResult executeCreatePreset(CreatePresetRequest createPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePresetRequestProtocolMarshaller(protocolFactory).marshall((CreatePresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePresetResult createPresetResult = (CreatePresetResult)response.getAwsResponse();
            return createPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) {
        request = (CreateQueueRequest)this.beforeClientExecution(request);
        return this.executeCreateQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateQueueResult executeCreateQueue(CreateQueueRequest createQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateQueueRequestProtocolMarshaller(protocolFactory).marshall((CreateQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)createQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateQueueResult createQueueResult = (CreateQueueResult)response.getAwsResponse();
            return createQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteJobTemplateResult deleteJobTemplate(DeleteJobTemplateRequest request) {
        request = (DeleteJobTemplateRequest)this.beforeClientExecution(request);
        return this.executeDeleteJobTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteJobTemplateResult executeDeleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteJobTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteJobTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteJobTemplateRequestProtocolMarshaller(protocolFactory).marshall((DeleteJobTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteJobTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteJobTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteJobTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteJobTemplateResult deleteJobTemplateResult = (DeleteJobTemplateResult)response.getAwsResponse();
            return deleteJobTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest request) {
        request = (DeletePresetRequest)this.beforeClientExecution(request);
        return this.executeDeletePreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePresetResult executeDeletePreset(DeletePresetRequest deletePresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePresetRequestProtocolMarshaller(protocolFactory).marshall((DeletePresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePresetResult deletePresetResult = (DeletePresetResult)response.getAwsResponse();
            return deletePresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) {
        request = (DeleteQueueRequest)this.beforeClientExecution(request);
        return this.executeDeleteQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteQueueResult executeDeleteQueue(DeleteQueueRequest deleteQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteQueueRequestProtocolMarshaller(protocolFactory).marshall((DeleteQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteQueueResult deleteQueueResult = (DeleteQueueResult)response.getAwsResponse();
            return deleteQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest request) {
        request = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEndpointsResult executeDescribeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEndpointsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEndpointsResult describeEndpointsResult = (DescribeEndpointsResult)response.getAwsResponse();
            return describeEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateCertificateResult disassociateCertificate(DisassociateCertificateRequest request) {
        request = (DisassociateCertificateRequest)this.beforeClientExecution(request);
        return this.executeDisassociateCertificate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateCertificateResult executeDisassociateCertificate(DisassociateCertificateRequest disassociateCertificateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateCertificateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateCertificateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateCertificateRequestProtocolMarshaller(protocolFactory).marshall((DisassociateCertificateRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateCertificateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateCertificate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateCertificateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateCertificateResult disassociateCertificateResult = (DisassociateCertificateResult)response.getAwsResponse();
            return disassociateCertificateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        request = (GetJobRequest)this.beforeClientExecution(request);
        return this.executeGetJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobResult executeGetJob(GetJobRequest getJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobRequestProtocolMarshaller(protocolFactory).marshall((GetJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobResult getJobResult = (GetJobResult)response.getAwsResponse();
            return getJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobTemplateResult getJobTemplate(GetJobTemplateRequest request) {
        request = (GetJobTemplateRequest)this.beforeClientExecution(request);
        return this.executeGetJobTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobTemplateResult executeGetJobTemplate(GetJobTemplateRequest getJobTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobTemplateRequestProtocolMarshaller(protocolFactory).marshall((GetJobTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJobTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobTemplateResult getJobTemplateResult = (GetJobTemplateResult)response.getAwsResponse();
            return getJobTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPresetResult getPreset(GetPresetRequest request) {
        request = (GetPresetRequest)this.beforeClientExecution(request);
        return this.executeGetPreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPresetResult executeGetPreset(GetPresetRequest getPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPresetRequestProtocolMarshaller(protocolFactory).marshall((GetPresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPresetResult getPresetResult = (GetPresetResult)response.getAwsResponse();
            return getPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQueueResult getQueue(GetQueueRequest request) {
        request = (GetQueueRequest)this.beforeClientExecution(request);
        return this.executeGetQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueueResult executeGetQueue(GetQueueRequest getQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueueRequestProtocolMarshaller(protocolFactory).marshall((GetQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQueueResult getQueueResult = (GetQueueResult)response.getAwsResponse();
            return getQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobTemplatesResult listJobTemplates(ListJobTemplatesRequest request) {
        request = (ListJobTemplatesRequest)this.beforeClientExecution(request);
        return this.executeListJobTemplates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobTemplatesResult executeListJobTemplates(ListJobTemplatesRequest listJobTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobTemplatesRequestProtocolMarshaller(protocolFactory).marshall((ListJobTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobTemplates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobTemplatesResult listJobTemplatesResult = (ListJobTemplatesResult)response.getAwsResponse();
            return listJobTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestProtocolMarshaller(protocolFactory).marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPresetsResult listPresets(ListPresetsRequest request) {
        request = (ListPresetsRequest)this.beforeClientExecution(request);
        return this.executeListPresets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPresetsResult executeListPresets(ListPresetsRequest listPresetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPresetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPresetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPresetsRequestProtocolMarshaller(protocolFactory).marshall((ListPresetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPresetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPresets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPresetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPresetsResult listPresetsResult = (ListPresetsResult)response.getAwsResponse();
            return listPresetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        request = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executeListQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueuesResult executeListQueues(ListQueuesRequest listQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueuesRequestProtocolMarshaller(protocolFactory).marshall((ListQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQueuesResult listQueuesResult = (ListQueuesResult)response.getAwsResponse();
            return listQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobTemplateResult updateJobTemplate(UpdateJobTemplateRequest request) {
        request = (UpdateJobTemplateRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobTemplateResult executeUpdateJobTemplate(UpdateJobTemplateRequest updateJobTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobTemplateRequestProtocolMarshaller(protocolFactory).marshall((UpdateJobTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobTemplateResult updateJobTemplateResult = (UpdateJobTemplateResult)response.getAwsResponse();
            return updateJobTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePresetResult updatePreset(UpdatePresetRequest request) {
        request = (UpdatePresetRequest)this.beforeClientExecution(request);
        return this.executeUpdatePreset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePresetResult executeUpdatePreset(UpdatePresetRequest updatePresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePresetRequestProtocolMarshaller(protocolFactory).marshall((UpdatePresetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePresetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePreset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePresetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePresetResult updatePresetResult = (UpdatePresetResult)response.getAwsResponse();
            return updatePresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateQueueResult updateQueue(UpdateQueueRequest request) {
        request = (UpdateQueueRequest)this.beforeClientExecution(request);
        return this.executeUpdateQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateQueueResult executeUpdateQueue(UpdateQueueRequest updateQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateQueueRequestProtocolMarshaller(protocolFactory).marshall((UpdateQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaConvert");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateQueueResult updateQueueResult = (UpdateQueueResult)response.getAwsResponse();
            return updateQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

