/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.mediaconnect.AWSMediaConnect;
import com.amazonaws.services.mediaconnect.model.DescribeFlowRequest;
import com.amazonaws.services.mediaconnect.waiters.DescribeFlowFunction;
import com.amazonaws.services.mediaconnect.waiters.FlowActive;
import com.amazonaws.services.mediaconnect.waiters.FlowDeleted;
import com.amazonaws.services.mediaconnect.waiters.FlowStandby;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AWSMediaConnectWaiters {
    private final AWSMediaConnect client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSMediaConnectWaiters");

    @SdkInternalApi
    public AWSMediaConnectWaiters(AWSMediaConnect client) {
        this.client = client;
    }

    public Waiter<DescribeFlowRequest> flowStandby() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFlowFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FlowStandby.IsSTANDBYMatcher(), new FlowStandby.IsSTOPPINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY), new HttpFailureStatusAcceptor(503, WaiterState.RETRY), new FlowStandby.IsERRORMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeFlowRequest> flowActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFlowFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FlowActive.IsACTIVEMatcher(), new FlowActive.IsSTARTINGMatcher(), new FlowActive.IsUPDATINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY), new HttpFailureStatusAcceptor(503, WaiterState.RETRY), new FlowActive.IsERRORMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeFlowRequest> flowDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFlowFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS), new FlowDeleted.IsDELETINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY), new HttpFailureStatusAcceptor(503, WaiterState.RETRY), new FlowDeleted.IsERRORMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

