/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsync;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsyncClientBuilder;
import com.amazonaws.services.mediaconnect.AWSMediaConnectClient;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsResult;
import com.amazonaws.services.mediaconnect.model.AddFlowSourcesRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowSourcesResult;
import com.amazonaws.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowVpcInterfacesResult;
import com.amazonaws.services.mediaconnect.model.CreateFlowRequest;
import com.amazonaws.services.mediaconnect.model.CreateFlowResult;
import com.amazonaws.services.mediaconnect.model.DeleteFlowRequest;
import com.amazonaws.services.mediaconnect.model.DeleteFlowResult;
import com.amazonaws.services.mediaconnect.model.DescribeFlowRequest;
import com.amazonaws.services.mediaconnect.model.DescribeFlowResult;
import com.amazonaws.services.mediaconnect.model.DescribeOfferingRequest;
import com.amazonaws.services.mediaconnect.model.DescribeOfferingResult;
import com.amazonaws.services.mediaconnect.model.DescribeReservationRequest;
import com.amazonaws.services.mediaconnect.model.DescribeReservationResult;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListFlowsRequest;
import com.amazonaws.services.mediaconnect.model.ListFlowsResult;
import com.amazonaws.services.mediaconnect.model.ListOfferingsRequest;
import com.amazonaws.services.mediaconnect.model.ListOfferingsResult;
import com.amazonaws.services.mediaconnect.model.ListReservationsRequest;
import com.amazonaws.services.mediaconnect.model.ListReservationsResult;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceResult;
import com.amazonaws.services.mediaconnect.model.PurchaseOfferingRequest;
import com.amazonaws.services.mediaconnect.model.PurchaseOfferingResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowSourceResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowVpcInterfaceResult;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.StartFlowRequest;
import com.amazonaws.services.mediaconnect.model.StartFlowResult;
import com.amazonaws.services.mediaconnect.model.StopFlowRequest;
import com.amazonaws.services.mediaconnect.model.StopFlowResult;
import com.amazonaws.services.mediaconnect.model.TagResourceRequest;
import com.amazonaws.services.mediaconnect.model.TagResourceResult;
import com.amazonaws.services.mediaconnect.model.UntagResourceRequest;
import com.amazonaws.services.mediaconnect.model.UntagResourceResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaConnectAsyncClient
extends AWSMediaConnectClient
implements AWSMediaConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaConnectAsyncClientBuilder asyncBuilder() {
        return AWSMediaConnectAsyncClientBuilder.standard();
    }

    AWSMediaConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaConnectAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request) {
        return this.addFlowOutputsAsync(request, null);
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request, final AsyncHandler<AddFlowOutputsRequest, AddFlowOutputsResult> asyncHandler) {
        final AddFlowOutputsRequest finalRequest = (AddFlowOutputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowOutputsResult>(){

            @Override
            public AddFlowOutputsResult call() throws Exception {
                AddFlowOutputsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowOutputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowSourcesResult> addFlowSourcesAsync(AddFlowSourcesRequest request) {
        return this.addFlowSourcesAsync(request, null);
    }

    @Override
    public Future<AddFlowSourcesResult> addFlowSourcesAsync(AddFlowSourcesRequest request, final AsyncHandler<AddFlowSourcesRequest, AddFlowSourcesResult> asyncHandler) {
        final AddFlowSourcesRequest finalRequest = (AddFlowSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowSourcesResult>(){

            @Override
            public AddFlowSourcesResult call() throws Exception {
                AddFlowSourcesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowVpcInterfacesResult> addFlowVpcInterfacesAsync(AddFlowVpcInterfacesRequest request) {
        return this.addFlowVpcInterfacesAsync(request, null);
    }

    @Override
    public Future<AddFlowVpcInterfacesResult> addFlowVpcInterfacesAsync(AddFlowVpcInterfacesRequest request, final AsyncHandler<AddFlowVpcInterfacesRequest, AddFlowVpcInterfacesResult> asyncHandler) {
        final AddFlowVpcInterfacesRequest finalRequest = (AddFlowVpcInterfacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowVpcInterfacesResult>(){

            @Override
            public AddFlowVpcInterfacesResult call() throws Exception {
                AddFlowVpcInterfacesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowVpcInterfaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request) {
        return this.createFlowAsync(request, null);
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request, final AsyncHandler<CreateFlowRequest, CreateFlowResult> asyncHandler) {
        final CreateFlowRequest finalRequest = (CreateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFlowResult>(){

            @Override
            public CreateFlowResult call() throws Exception {
                CreateFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeCreateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request) {
        return this.deleteFlowAsync(request, null);
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request, final AsyncHandler<DeleteFlowRequest, DeleteFlowResult> asyncHandler) {
        final DeleteFlowRequest finalRequest = (DeleteFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFlowResult>(){

            @Override
            public DeleteFlowResult call() throws Exception {
                DeleteFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeleteFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request) {
        return this.describeFlowAsync(request, null);
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request, final AsyncHandler<DescribeFlowRequest, DescribeFlowResult> asyncHandler) {
        final DescribeFlowRequest finalRequest = (DescribeFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowResult>(){

            @Override
            public DescribeFlowResult call() throws Exception {
                DescribeFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request) {
        return this.describeOfferingAsync(request, null);
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request, final AsyncHandler<DescribeOfferingRequest, DescribeOfferingResult> asyncHandler) {
        final DescribeOfferingRequest finalRequest = (DescribeOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOfferingResult>(){

            @Override
            public DescribeOfferingResult call() throws Exception {
                DescribeOfferingResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request) {
        return this.describeReservationAsync(request, null);
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request, final AsyncHandler<DescribeReservationRequest, DescribeReservationResult> asyncHandler) {
        final DescribeReservationRequest finalRequest = (DescribeReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservationResult>(){

            @Override
            public DescribeReservationResult call() throws Exception {
                DescribeReservationResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request) {
        return this.grantFlowEntitlementsAsync(request, null);
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request, final AsyncHandler<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResult> asyncHandler) {
        final GrantFlowEntitlementsRequest finalRequest = (GrantFlowEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantFlowEntitlementsResult>(){

            @Override
            public GrantFlowEntitlementsResult call() throws Exception {
                GrantFlowEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeGrantFlowEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request) {
        return this.listEntitlementsAsync(request, null);
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request, final AsyncHandler<ListEntitlementsRequest, ListEntitlementsResult> asyncHandler) {
        final ListEntitlementsRequest finalRequest = (ListEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitlementsResult>(){

            @Override
            public ListEntitlementsResult call() throws Exception {
                ListEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request) {
        return this.listFlowsAsync(request, null);
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request, final AsyncHandler<ListFlowsRequest, ListFlowsResult> asyncHandler) {
        final ListFlowsRequest finalRequest = (ListFlowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFlowsResult>(){

            @Override
            public ListFlowsResult call() throws Exception {
                ListFlowsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListFlows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request) {
        return this.listOfferingsAsync(request, null);
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request, final AsyncHandler<ListOfferingsRequest, ListOfferingsResult> asyncHandler) {
        final ListOfferingsRequest finalRequest = (ListOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOfferingsResult>(){

            @Override
            public ListOfferingsResult call() throws Exception {
                ListOfferingsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request) {
        return this.listReservationsAsync(request, null);
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request, final AsyncHandler<ListReservationsRequest, ListReservationsResult> asyncHandler) {
        final ListReservationsRequest finalRequest = (ListReservationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReservationsResult>(){

            @Override
            public ListReservationsResult call() throws Exception {
                ListReservationsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListReservations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request) {
        return this.purchaseOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request, final AsyncHandler<PurchaseOfferingRequest, PurchaseOfferingResult> asyncHandler) {
        final PurchaseOfferingRequest finalRequest = (PurchaseOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurchaseOfferingResult>(){

            @Override
            public PurchaseOfferingResult call() throws Exception {
                PurchaseOfferingResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executePurchaseOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request) {
        return this.removeFlowOutputAsync(request, null);
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request, final AsyncHandler<RemoveFlowOutputRequest, RemoveFlowOutputResult> asyncHandler) {
        final RemoveFlowOutputRequest finalRequest = (RemoveFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowOutputResult>(){

            @Override
            public RemoveFlowOutputResult call() throws Exception {
                RemoveFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowSourceResult> removeFlowSourceAsync(RemoveFlowSourceRequest request) {
        return this.removeFlowSourceAsync(request, null);
    }

    @Override
    public Future<RemoveFlowSourceResult> removeFlowSourceAsync(RemoveFlowSourceRequest request, final AsyncHandler<RemoveFlowSourceRequest, RemoveFlowSourceResult> asyncHandler) {
        final RemoveFlowSourceRequest finalRequest = (RemoveFlowSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowSourceResult>(){

            @Override
            public RemoveFlowSourceResult call() throws Exception {
                RemoveFlowSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowVpcInterfaceResult> removeFlowVpcInterfaceAsync(RemoveFlowVpcInterfaceRequest request) {
        return this.removeFlowVpcInterfaceAsync(request, null);
    }

    @Override
    public Future<RemoveFlowVpcInterfaceResult> removeFlowVpcInterfaceAsync(RemoveFlowVpcInterfaceRequest request, final AsyncHandler<RemoveFlowVpcInterfaceRequest, RemoveFlowVpcInterfaceResult> asyncHandler) {
        final RemoveFlowVpcInterfaceRequest finalRequest = (RemoveFlowVpcInterfaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowVpcInterfaceResult>(){

            @Override
            public RemoveFlowVpcInterfaceResult call() throws Exception {
                RemoveFlowVpcInterfaceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowVpcInterface(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request) {
        return this.revokeFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request, final AsyncHandler<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResult> asyncHandler) {
        final RevokeFlowEntitlementRequest finalRequest = (RevokeFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeFlowEntitlementResult>(){

            @Override
            public RevokeFlowEntitlementResult call() throws Exception {
                RevokeFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRevokeFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request) {
        return this.startFlowAsync(request, null);
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request, final AsyncHandler<StartFlowRequest, StartFlowResult> asyncHandler) {
        final StartFlowRequest finalRequest = (StartFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFlowResult>(){

            @Override
            public StartFlowResult call() throws Exception {
                StartFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStartFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request) {
        return this.stopFlowAsync(request, null);
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request, final AsyncHandler<StopFlowRequest, StopFlowResult> asyncHandler) {
        final StopFlowRequest finalRequest = (StopFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFlowResult>(){

            @Override
            public StopFlowResult call() throws Exception {
                StopFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStopFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request) {
        return this.updateFlowAsync(request, null);
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request, final AsyncHandler<UpdateFlowRequest, UpdateFlowResult> asyncHandler) {
        final UpdateFlowRequest finalRequest = (UpdateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowResult>(){

            @Override
            public UpdateFlowResult call() throws Exception {
                UpdateFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request) {
        return this.updateFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request, final AsyncHandler<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResult> asyncHandler) {
        final UpdateFlowEntitlementRequest finalRequest = (UpdateFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowEntitlementResult>(){

            @Override
            public UpdateFlowEntitlementResult call() throws Exception {
                UpdateFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request) {
        return this.updateFlowOutputAsync(request, null);
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request, final AsyncHandler<UpdateFlowOutputRequest, UpdateFlowOutputResult> asyncHandler) {
        final UpdateFlowOutputRequest finalRequest = (UpdateFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowOutputResult>(){

            @Override
            public UpdateFlowOutputResult call() throws Exception {
                UpdateFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request) {
        return this.updateFlowSourceAsync(request, null);
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request, final AsyncHandler<UpdateFlowSourceRequest, UpdateFlowSourceResult> asyncHandler) {
        final UpdateFlowSourceRequest finalRequest = (UpdateFlowSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowSourceResult>(){

            @Override
            public UpdateFlowSourceResult call() throws Exception {
                UpdateFlowSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

