/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotifyWorkersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String subject;
    private String messageText;
    private List<String> workerIds;

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public NotifyWorkersRequest withSubject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public NotifyWorkersRequest withMessageText(String messageText) {
        this.setMessageText(messageText);
        return this;
    }

    public List<String> getWorkerIds() {
        return this.workerIds;
    }

    public void setWorkerIds(Collection<String> workerIds) {
        if (workerIds == null) {
            this.workerIds = null;
            return;
        }
        this.workerIds = new ArrayList<String>(workerIds);
    }

    public NotifyWorkersRequest withWorkerIds(String ... workerIds) {
        if (this.workerIds == null) {
            this.setWorkerIds(new ArrayList<String>(workerIds.length));
        }
        for (String ele : workerIds) {
            this.workerIds.add(ele);
        }
        return this;
    }

    public NotifyWorkersRequest withWorkerIds(Collection<String> workerIds) {
        this.setWorkerIds(workerIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject()).append(",");
        }
        if (this.getMessageText() != null) {
            sb.append("MessageText: ").append(this.getMessageText()).append(",");
        }
        if (this.getWorkerIds() != null) {
            sb.append("WorkerIds: ").append(this.getWorkerIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersRequest)) {
            return false;
        }
        NotifyWorkersRequest other = (NotifyWorkersRequest)obj;
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getMessageText() == null ^ this.getMessageText() == null) {
            return false;
        }
        if (other.getMessageText() != null && !other.getMessageText().equals(this.getMessageText())) {
            return false;
        }
        if (other.getWorkerIds() == null ^ this.getWorkerIds() == null) {
            return false;
        }
        return other.getWorkerIds() == null || other.getWorkerIds().equals(this.getWorkerIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getMessageText() == null ? 0 : this.getMessageText().hashCode());
        hashCode = 31 * hashCode + (this.getWorkerIds() == null ? 0 : this.getWorkerIds().hashCode());
        return hashCode;
    }

    public NotifyWorkersRequest clone() {
        return (NotifyWorkersRequest)super.clone();
    }
}

