/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecommerceanalytics.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class StartSupportDataExportRequestMarshaller
implements Marshaller<Request<StartSupportDataExportRequest>, StartSupportDataExportRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public StartSupportDataExportRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartSupportDataExportRequest> marshall(StartSupportDataExportRequest startSupportDataExportRequest) {
        if (startSupportDataExportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startSupportDataExportRequest, "AWSMarketplaceCommerceAnalytics");
        request.addHeader("X-Amz-Target", "MarketplaceCommerceAnalytics20150701.StartSupportDataExport");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> customerDefinedValuesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startSupportDataExportRequest.getDataSetType() != null) {
                jsonGenerator.writeFieldName("dataSetType").writeValue(startSupportDataExportRequest.getDataSetType());
            }
            if (startSupportDataExportRequest.getFromDate() != null) {
                jsonGenerator.writeFieldName("fromDate").writeValue(startSupportDataExportRequest.getFromDate());
            }
            if (startSupportDataExportRequest.getRoleNameArn() != null) {
                jsonGenerator.writeFieldName("roleNameArn").writeValue(startSupportDataExportRequest.getRoleNameArn());
            }
            if (startSupportDataExportRequest.getDestinationS3BucketName() != null) {
                jsonGenerator.writeFieldName("destinationS3BucketName").writeValue(startSupportDataExportRequest.getDestinationS3BucketName());
            }
            if (startSupportDataExportRequest.getDestinationS3Prefix() != null) {
                jsonGenerator.writeFieldName("destinationS3Prefix").writeValue(startSupportDataExportRequest.getDestinationS3Prefix());
            }
            if (startSupportDataExportRequest.getSnsTopicArn() != null) {
                jsonGenerator.writeFieldName("snsTopicArn").writeValue(startSupportDataExportRequest.getSnsTopicArn());
            }
            if ((customerDefinedValuesMap = startSupportDataExportRequest.getCustomerDefinedValues()) != null) {
                jsonGenerator.writeFieldName("customerDefinedValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> customerDefinedValuesMapValue : customerDefinedValuesMap.entrySet()) {
                    if (customerDefinedValuesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(customerDefinedValuesMapValue.getKey());
                    jsonGenerator.writeValue(customerDefinedValuesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

