/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.managedgrafana.model.NetworkAccessConfiguration;
import java.util.List;

@SdkInternalApi
public class NetworkAccessConfigurationMarshaller {
    private static final MarshallingInfo<List> PREFIXLISTIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefixListIds").build();
    private static final MarshallingInfo<List> VPCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpceIds").build();
    private static final NetworkAccessConfigurationMarshaller instance = new NetworkAccessConfigurationMarshaller();

    public static NetworkAccessConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkAccessConfiguration networkAccessConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (networkAccessConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(networkAccessConfiguration.getPrefixListIds(), PREFIXLISTIDS_BINDING);
            protocolMarshaller.marshall(networkAccessConfiguration.getVpceIds(), VPCEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

