/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mainframemodernization.model.ExternalLocation;

@SdkInternalApi
public class ExternalLocationMarshaller {
    private static final MarshallingInfo<String> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final ExternalLocationMarshaller instance = new ExternalLocationMarshaller();

    public static ExternalLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExternalLocation externalLocation, ProtocolMarshaller protocolMarshaller) {
        if (externalLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)externalLocation.getS3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

