/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PredictRequestMarshaller
implements Marshaller<Request<PredictRequest>, PredictRequest> {
    public Request<PredictRequest> marshall(PredictRequest predictRequest) {
        if (predictRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)predictRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.Predict");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap recordMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (predictRequest.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(predictRequest.getMLModelId());
            }
            if (!(recordMap = (SdkInternalMap)predictRequest.getRecord()).isEmpty() || !recordMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Record");
                jsonGenerator.writeStartObject();
                for (Map.Entry recordMapValue : recordMap.entrySet()) {
                    if (recordMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)recordMapValue.getKey());
                    jsonGenerator.writeValue((String)recordMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (predictRequest.getPredictEndpoint() != null) {
                jsonGenerator.writeFieldName("PredictEndpoint").writeValue(predictRequest.getPredictEndpoint());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

