/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutforvision.model.Anomaly;
import com.amazonaws.services.lookoutforvision.model.ImageSource;
import com.amazonaws.services.lookoutforvision.model.transform.DetectAnomalyResultMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectAnomalyResult
implements Serializable,
Cloneable,
StructuredPojo {
    private ImageSource source;
    private Boolean isAnomalous;
    private Float confidence;
    private List<Anomaly> anomalies;
    private ByteBuffer anomalyMask;

    public void setSource(ImageSource source) {
        this.source = source;
    }

    public ImageSource getSource() {
        return this.source;
    }

    public DetectAnomalyResult withSource(ImageSource source) {
        this.setSource(source);
        return this;
    }

    public void setIsAnomalous(Boolean isAnomalous) {
        this.isAnomalous = isAnomalous;
    }

    public Boolean getIsAnomalous() {
        return this.isAnomalous;
    }

    public DetectAnomalyResult withIsAnomalous(Boolean isAnomalous) {
        this.setIsAnomalous(isAnomalous);
        return this;
    }

    public Boolean isAnomalous() {
        return this.isAnomalous;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public DetectAnomalyResult withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public List<Anomaly> getAnomalies() {
        return this.anomalies;
    }

    public void setAnomalies(Collection<Anomaly> anomalies) {
        if (anomalies == null) {
            this.anomalies = null;
            return;
        }
        this.anomalies = new ArrayList<Anomaly>(anomalies);
    }

    public DetectAnomalyResult withAnomalies(Anomaly ... anomalies) {
        if (this.anomalies == null) {
            this.setAnomalies(new ArrayList<Anomaly>(anomalies.length));
        }
        for (Anomaly ele : anomalies) {
            this.anomalies.add(ele);
        }
        return this;
    }

    public DetectAnomalyResult withAnomalies(Collection<Anomaly> anomalies) {
        this.setAnomalies(anomalies);
        return this;
    }

    public void setAnomalyMask(ByteBuffer anomalyMask) {
        this.anomalyMask = anomalyMask;
    }

    public ByteBuffer getAnomalyMask() {
        return this.anomalyMask;
    }

    public DetectAnomalyResult withAnomalyMask(ByteBuffer anomalyMask) {
        this.setAnomalyMask(anomalyMask);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getIsAnomalous() != null) {
            sb.append("IsAnomalous: ").append(this.getIsAnomalous()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getAnomalies() != null) {
            sb.append("Anomalies: ").append(this.getAnomalies()).append(",");
        }
        if (this.getAnomalyMask() != null) {
            sb.append("AnomalyMask: ").append(this.getAnomalyMask());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomalyResult)) {
            return false;
        }
        DetectAnomalyResult other = (DetectAnomalyResult)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getIsAnomalous() == null ^ this.getIsAnomalous() == null) {
            return false;
        }
        if (other.getIsAnomalous() != null && !other.getIsAnomalous().equals(this.getIsAnomalous())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getAnomalies() == null ^ this.getAnomalies() == null) {
            return false;
        }
        if (other.getAnomalies() != null && !other.getAnomalies().equals(this.getAnomalies())) {
            return false;
        }
        if (other.getAnomalyMask() == null ^ this.getAnomalyMask() == null) {
            return false;
        }
        return other.getAnomalyMask() == null || other.getAnomalyMask().equals(this.getAnomalyMask());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getIsAnomalous() == null ? 0 : this.getIsAnomalous().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getAnomalies() == null ? 0 : this.getAnomalies().hashCode());
        hashCode = 31 * hashCode + (this.getAnomalyMask() == null ? 0 : this.getAnomalyMask().hashCode());
        return hashCode;
    }

    public DetectAnomalyResult clone() {
        try {
            return (DetectAnomalyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DetectAnomalyResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

