/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.logs.model.MetricTransformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricFilter
implements Serializable,
Cloneable {
    private String filterName;
    private String filterPattern;
    private ListWithAutoConstructFlag<MetricTransformation> metricTransformations;
    private Long creationTime;

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public MetricFilter withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public MetricFilter withFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        return this;
    }

    public List<MetricTransformation> getMetricTransformations() {
        if (this.metricTransformations == null) {
            this.metricTransformations = new ListWithAutoConstructFlag();
            this.metricTransformations.setAutoConstruct(true);
        }
        return this.metricTransformations;
    }

    public void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
            return;
        }
        ListWithAutoConstructFlag metricTransformationsCopy = new ListWithAutoConstructFlag(metricTransformations.size());
        metricTransformationsCopy.addAll(metricTransformations);
        this.metricTransformations = metricTransformationsCopy;
    }

    public MetricFilter withMetricTransformations(MetricTransformation ... metricTransformations) {
        if (this.getMetricTransformations() == null) {
            this.setMetricTransformations(new ArrayList<MetricTransformation>(metricTransformations.length));
        }
        for (MetricTransformation value : metricTransformations) {
            this.getMetricTransformations().add(value);
        }
        return this;
    }

    public MetricFilter withMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
        } else {
            ListWithAutoConstructFlag metricTransformationsCopy = new ListWithAutoConstructFlag(metricTransformations.size());
            metricTransformationsCopy.addAll(metricTransformations);
            this.metricTransformations = metricTransformationsCopy;
        }
        return this;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public MetricFilter withCreationTime(Long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterName() != null) {
            sb.append("FilterName: " + this.getFilterName() + ",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: " + this.getFilterPattern() + ",");
        }
        if (this.getMetricTransformations() != null) {
            sb.append("MetricTransformations: " + this.getMetricTransformations() + ",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: " + this.getCreationTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterName() == null ? 0 : this.getFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getMetricTransformations() == null ? 0 : this.getMetricTransformations().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter)obj;
        if (other.getFilterName() == null ^ this.getFilterName() == null) {
            return false;
        }
        if (other.getFilterName() != null && !other.getFilterName().equals(this.getFilterName())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getMetricTransformations() == null ^ this.getMetricTransformations() == null) {
            return false;
        }
        if (other.getMetricTransformations() != null && !other.getMetricTransformations().equals(this.getMetricTransformations())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        return other.getCreationTime() == null || other.getCreationTime().equals(this.getCreationTime());
    }

    public MetricFilter clone() {
        try {
            return (MetricFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

