/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.location.model.CalculateRouteCarModeOptions;
import com.amazonaws.services.location.model.CalculateRouteTruckModeOptions;
import com.amazonaws.services.location.model.DistanceUnit;
import com.amazonaws.services.location.model.TravelMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CalculateRouteMatrixRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String calculatorName;
    private CalculateRouteCarModeOptions carModeOptions;
    private Boolean departNow;
    private List<List<Double>> departurePositions;
    private Date departureTime;
    private List<List<Double>> destinationPositions;
    private String distanceUnit;
    private String travelMode;
    private CalculateRouteTruckModeOptions truckModeOptions;

    public void setCalculatorName(String calculatorName) {
        this.calculatorName = calculatorName;
    }

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public CalculateRouteMatrixRequest withCalculatorName(String calculatorName) {
        this.setCalculatorName(calculatorName);
        return this;
    }

    public void setCarModeOptions(CalculateRouteCarModeOptions carModeOptions) {
        this.carModeOptions = carModeOptions;
    }

    public CalculateRouteCarModeOptions getCarModeOptions() {
        return this.carModeOptions;
    }

    public CalculateRouteMatrixRequest withCarModeOptions(CalculateRouteCarModeOptions carModeOptions) {
        this.setCarModeOptions(carModeOptions);
        return this;
    }

    public void setDepartNow(Boolean departNow) {
        this.departNow = departNow;
    }

    public Boolean getDepartNow() {
        return this.departNow;
    }

    public CalculateRouteMatrixRequest withDepartNow(Boolean departNow) {
        this.setDepartNow(departNow);
        return this;
    }

    public Boolean isDepartNow() {
        return this.departNow;
    }

    public List<List<Double>> getDeparturePositions() {
        return this.departurePositions;
    }

    public void setDeparturePositions(Collection<List<Double>> departurePositions) {
        if (departurePositions == null) {
            this.departurePositions = null;
            return;
        }
        this.departurePositions = new ArrayList<List<Double>>(departurePositions);
    }

    public CalculateRouteMatrixRequest withDeparturePositions(List<Double> ... departurePositions) {
        if (this.departurePositions == null) {
            this.setDeparturePositions(new ArrayList<List<Double>>(departurePositions.length));
        }
        for (List<Double> ele : departurePositions) {
            this.departurePositions.add(ele);
        }
        return this;
    }

    public CalculateRouteMatrixRequest withDeparturePositions(Collection<List<Double>> departurePositions) {
        this.setDeparturePositions(departurePositions);
        return this;
    }

    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    public Date getDepartureTime() {
        return this.departureTime;
    }

    public CalculateRouteMatrixRequest withDepartureTime(Date departureTime) {
        this.setDepartureTime(departureTime);
        return this;
    }

    public List<List<Double>> getDestinationPositions() {
        return this.destinationPositions;
    }

    public void setDestinationPositions(Collection<List<Double>> destinationPositions) {
        if (destinationPositions == null) {
            this.destinationPositions = null;
            return;
        }
        this.destinationPositions = new ArrayList<List<Double>>(destinationPositions);
    }

    public CalculateRouteMatrixRequest withDestinationPositions(List<Double> ... destinationPositions) {
        if (this.destinationPositions == null) {
            this.setDestinationPositions(new ArrayList<List<Double>>(destinationPositions.length));
        }
        for (List<Double> ele : destinationPositions) {
            this.destinationPositions.add(ele);
        }
        return this;
    }

    public CalculateRouteMatrixRequest withDestinationPositions(Collection<List<Double>> destinationPositions) {
        this.setDestinationPositions(destinationPositions);
        return this;
    }

    public void setDistanceUnit(String distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public String getDistanceUnit() {
        return this.distanceUnit;
    }

    public CalculateRouteMatrixRequest withDistanceUnit(String distanceUnit) {
        this.setDistanceUnit(distanceUnit);
        return this;
    }

    public CalculateRouteMatrixRequest withDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit.toString();
        return this;
    }

    public void setTravelMode(String travelMode) {
        this.travelMode = travelMode;
    }

    public String getTravelMode() {
        return this.travelMode;
    }

    public CalculateRouteMatrixRequest withTravelMode(String travelMode) {
        this.setTravelMode(travelMode);
        return this;
    }

    public CalculateRouteMatrixRequest withTravelMode(TravelMode travelMode) {
        this.travelMode = travelMode.toString();
        return this;
    }

    public void setTruckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
        this.truckModeOptions = truckModeOptions;
    }

    public CalculateRouteTruckModeOptions getTruckModeOptions() {
        return this.truckModeOptions;
    }

    public CalculateRouteMatrixRequest withTruckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
        this.setTruckModeOptions(truckModeOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCalculatorName() != null) {
            sb.append("CalculatorName: ").append(this.getCalculatorName()).append(",");
        }
        if (this.getCarModeOptions() != null) {
            sb.append("CarModeOptions: ").append(this.getCarModeOptions()).append(",");
        }
        if (this.getDepartNow() != null) {
            sb.append("DepartNow: ").append(this.getDepartNow()).append(",");
        }
        if (this.getDeparturePositions() != null) {
            sb.append("DeparturePositions: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDepartureTime() != null) {
            sb.append("DepartureTime: ").append(this.getDepartureTime()).append(",");
        }
        if (this.getDestinationPositions() != null) {
            sb.append("DestinationPositions: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDistanceUnit() != null) {
            sb.append("DistanceUnit: ").append(this.getDistanceUnit()).append(",");
        }
        if (this.getTravelMode() != null) {
            sb.append("TravelMode: ").append(this.getTravelMode()).append(",");
        }
        if (this.getTruckModeOptions() != null) {
            sb.append("TruckModeOptions: ").append(this.getTruckModeOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixRequest)) {
            return false;
        }
        CalculateRouteMatrixRequest other = (CalculateRouteMatrixRequest)obj;
        if (other.getCalculatorName() == null ^ this.getCalculatorName() == null) {
            return false;
        }
        if (other.getCalculatorName() != null && !other.getCalculatorName().equals(this.getCalculatorName())) {
            return false;
        }
        if (other.getCarModeOptions() == null ^ this.getCarModeOptions() == null) {
            return false;
        }
        if (other.getCarModeOptions() != null && !other.getCarModeOptions().equals(this.getCarModeOptions())) {
            return false;
        }
        if (other.getDepartNow() == null ^ this.getDepartNow() == null) {
            return false;
        }
        if (other.getDepartNow() != null && !other.getDepartNow().equals(this.getDepartNow())) {
            return false;
        }
        if (other.getDeparturePositions() == null ^ this.getDeparturePositions() == null) {
            return false;
        }
        if (other.getDeparturePositions() != null && !other.getDeparturePositions().equals(this.getDeparturePositions())) {
            return false;
        }
        if (other.getDepartureTime() == null ^ this.getDepartureTime() == null) {
            return false;
        }
        if (other.getDepartureTime() != null && !other.getDepartureTime().equals(this.getDepartureTime())) {
            return false;
        }
        if (other.getDestinationPositions() == null ^ this.getDestinationPositions() == null) {
            return false;
        }
        if (other.getDestinationPositions() != null && !other.getDestinationPositions().equals(this.getDestinationPositions())) {
            return false;
        }
        if (other.getDistanceUnit() == null ^ this.getDistanceUnit() == null) {
            return false;
        }
        if (other.getDistanceUnit() != null && !other.getDistanceUnit().equals(this.getDistanceUnit())) {
            return false;
        }
        if (other.getTravelMode() == null ^ this.getTravelMode() == null) {
            return false;
        }
        if (other.getTravelMode() != null && !other.getTravelMode().equals(this.getTravelMode())) {
            return false;
        }
        if (other.getTruckModeOptions() == null ^ this.getTruckModeOptions() == null) {
            return false;
        }
        return other.getTruckModeOptions() == null || other.getTruckModeOptions().equals(this.getTruckModeOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCalculatorName() == null ? 0 : this.getCalculatorName().hashCode());
        hashCode = 31 * hashCode + (this.getCarModeOptions() == null ? 0 : this.getCarModeOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDepartNow() == null ? 0 : this.getDepartNow().hashCode());
        hashCode = 31 * hashCode + (this.getDeparturePositions() == null ? 0 : this.getDeparturePositions().hashCode());
        hashCode = 31 * hashCode + (this.getDepartureTime() == null ? 0 : this.getDepartureTime().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPositions() == null ? 0 : this.getDestinationPositions().hashCode());
        hashCode = 31 * hashCode + (this.getDistanceUnit() == null ? 0 : this.getDistanceUnit().hashCode());
        hashCode = 31 * hashCode + (this.getTravelMode() == null ? 0 : this.getTravelMode().hashCode());
        hashCode = 31 * hashCode + (this.getTruckModeOptions() == null ? 0 : this.getTruckModeOptions().hashCode());
        return hashCode;
    }

    public CalculateRouteMatrixRequest clone() {
        return (CalculateRouteMatrixRequest)super.clone();
    }
}

