/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.services.lightsail.model.Bundle;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class BundleJsonUnmarshaller
implements Unmarshaller<Bundle, JsonUnmarshallerContext> {
    private static BundleJsonUnmarshaller instance;

    public Bundle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bundle bundle = new Bundle();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("price", targetDepth)) {
                    context.nextToken();
                    bundle.setPrice((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("cpuCount", targetDepth)) {
                    context.nextToken();
                    bundle.setCpuCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("diskSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setDiskSizeInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    bundle.setBundleId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    context.nextToken();
                    bundle.setInstanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    bundle.setIsActive((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    bundle.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("power", targetDepth)) {
                    context.nextToken();
                    bundle.setPower((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ramSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setRamSizeInGb((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("transferPerMonthInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setTransferPerMonthInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return bundle;
    }

    public static BundleJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BundleJsonUnmarshaller();
        }
        return instance;
    }
}

