/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.ConsumptionConfiguration;
import com.amazonaws.services.licensemanager.model.DatetimeRange;
import com.amazonaws.services.licensemanager.model.Entitlement;
import com.amazonaws.services.licensemanager.model.IssuerDetails;
import com.amazonaws.services.licensemanager.model.LicenseStatus;
import com.amazonaws.services.licensemanager.model.Metadata;
import com.amazonaws.services.licensemanager.model.ReceivedMetadata;
import com.amazonaws.services.licensemanager.model.transform.GrantedLicenseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GrantedLicense
implements Serializable,
Cloneable,
StructuredPojo {
    private String licenseArn;
    private String licenseName;
    private String productName;
    private String productSKU;
    private IssuerDetails issuer;
    private String homeRegion;
    private String status;
    private DatetimeRange validity;
    private String beneficiary;
    private List<Entitlement> entitlements;
    private ConsumptionConfiguration consumptionConfiguration;
    private List<Metadata> licenseMetadata;
    private String createTime;
    private String version;
    private ReceivedMetadata receivedMetadata;

    public void setLicenseArn(String licenseArn) {
        this.licenseArn = licenseArn;
    }

    public String getLicenseArn() {
        return this.licenseArn;
    }

    public GrantedLicense withLicenseArn(String licenseArn) {
        this.setLicenseArn(licenseArn);
        return this;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public GrantedLicense withLicenseName(String licenseName) {
        this.setLicenseName(licenseName);
        return this;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public GrantedLicense withProductName(String productName) {
        this.setProductName(productName);
        return this;
    }

    public void setProductSKU(String productSKU) {
        this.productSKU = productSKU;
    }

    public String getProductSKU() {
        return this.productSKU;
    }

    public GrantedLicense withProductSKU(String productSKU) {
        this.setProductSKU(productSKU);
        return this;
    }

    public void setIssuer(IssuerDetails issuer) {
        this.issuer = issuer;
    }

    public IssuerDetails getIssuer() {
        return this.issuer;
    }

    public GrantedLicense withIssuer(IssuerDetails issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setHomeRegion(String homeRegion) {
        this.homeRegion = homeRegion;
    }

    public String getHomeRegion() {
        return this.homeRegion;
    }

    public GrantedLicense withHomeRegion(String homeRegion) {
        this.setHomeRegion(homeRegion);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GrantedLicense withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GrantedLicense withStatus(LicenseStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setValidity(DatetimeRange validity) {
        this.validity = validity;
    }

    public DatetimeRange getValidity() {
        return this.validity;
    }

    public GrantedLicense withValidity(DatetimeRange validity) {
        this.setValidity(validity);
        return this;
    }

    public void setBeneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
    }

    public String getBeneficiary() {
        return this.beneficiary;
    }

    public GrantedLicense withBeneficiary(String beneficiary) {
        this.setBeneficiary(beneficiary);
        return this;
    }

    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(Collection<Entitlement> entitlements) {
        if (entitlements == null) {
            this.entitlements = null;
            return;
        }
        this.entitlements = new ArrayList<Entitlement>(entitlements);
    }

    public GrantedLicense withEntitlements(Entitlement ... entitlements) {
        if (this.entitlements == null) {
            this.setEntitlements(new ArrayList<Entitlement>(entitlements.length));
        }
        for (Entitlement ele : entitlements) {
            this.entitlements.add(ele);
        }
        return this;
    }

    public GrantedLicense withEntitlements(Collection<Entitlement> entitlements) {
        this.setEntitlements(entitlements);
        return this;
    }

    public void setConsumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
        this.consumptionConfiguration = consumptionConfiguration;
    }

    public ConsumptionConfiguration getConsumptionConfiguration() {
        return this.consumptionConfiguration;
    }

    public GrantedLicense withConsumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
        this.setConsumptionConfiguration(consumptionConfiguration);
        return this;
    }

    public List<Metadata> getLicenseMetadata() {
        return this.licenseMetadata;
    }

    public void setLicenseMetadata(Collection<Metadata> licenseMetadata) {
        if (licenseMetadata == null) {
            this.licenseMetadata = null;
            return;
        }
        this.licenseMetadata = new ArrayList<Metadata>(licenseMetadata);
    }

    public GrantedLicense withLicenseMetadata(Metadata ... licenseMetadata) {
        if (this.licenseMetadata == null) {
            this.setLicenseMetadata(new ArrayList<Metadata>(licenseMetadata.length));
        }
        for (Metadata ele : licenseMetadata) {
            this.licenseMetadata.add(ele);
        }
        return this;
    }

    public GrantedLicense withLicenseMetadata(Collection<Metadata> licenseMetadata) {
        this.setLicenseMetadata(licenseMetadata);
        return this;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public GrantedLicense withCreateTime(String createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public GrantedLicense withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setReceivedMetadata(ReceivedMetadata receivedMetadata) {
        this.receivedMetadata = receivedMetadata;
    }

    public ReceivedMetadata getReceivedMetadata() {
        return this.receivedMetadata;
    }

    public GrantedLicense withReceivedMetadata(ReceivedMetadata receivedMetadata) {
        this.setReceivedMetadata(receivedMetadata);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseArn() != null) {
            sb.append("LicenseArn: ").append(this.getLicenseArn()).append(",");
        }
        if (this.getLicenseName() != null) {
            sb.append("LicenseName: ").append(this.getLicenseName()).append(",");
        }
        if (this.getProductName() != null) {
            sb.append("ProductName: ").append(this.getProductName()).append(",");
        }
        if (this.getProductSKU() != null) {
            sb.append("ProductSKU: ").append(this.getProductSKU()).append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getHomeRegion() != null) {
            sb.append("HomeRegion: ").append(this.getHomeRegion()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getValidity() != null) {
            sb.append("Validity: ").append(this.getValidity()).append(",");
        }
        if (this.getBeneficiary() != null) {
            sb.append("Beneficiary: ").append(this.getBeneficiary()).append(",");
        }
        if (this.getEntitlements() != null) {
            sb.append("Entitlements: ").append(this.getEntitlements()).append(",");
        }
        if (this.getConsumptionConfiguration() != null) {
            sb.append("ConsumptionConfiguration: ").append(this.getConsumptionConfiguration()).append(",");
        }
        if (this.getLicenseMetadata() != null) {
            sb.append("LicenseMetadata: ").append(this.getLicenseMetadata()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getReceivedMetadata() != null) {
            sb.append("ReceivedMetadata: ").append(this.getReceivedMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantedLicense)) {
            return false;
        }
        GrantedLicense other = (GrantedLicense)obj;
        if (other.getLicenseArn() == null ^ this.getLicenseArn() == null) {
            return false;
        }
        if (other.getLicenseArn() != null && !other.getLicenseArn().equals(this.getLicenseArn())) {
            return false;
        }
        if (other.getLicenseName() == null ^ this.getLicenseName() == null) {
            return false;
        }
        if (other.getLicenseName() != null && !other.getLicenseName().equals(this.getLicenseName())) {
            return false;
        }
        if (other.getProductName() == null ^ this.getProductName() == null) {
            return false;
        }
        if (other.getProductName() != null && !other.getProductName().equals(this.getProductName())) {
            return false;
        }
        if (other.getProductSKU() == null ^ this.getProductSKU() == null) {
            return false;
        }
        if (other.getProductSKU() != null && !other.getProductSKU().equals(this.getProductSKU())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getHomeRegion() == null ^ this.getHomeRegion() == null) {
            return false;
        }
        if (other.getHomeRegion() != null && !other.getHomeRegion().equals(this.getHomeRegion())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getValidity() == null ^ this.getValidity() == null) {
            return false;
        }
        if (other.getValidity() != null && !other.getValidity().equals(this.getValidity())) {
            return false;
        }
        if (other.getBeneficiary() == null ^ this.getBeneficiary() == null) {
            return false;
        }
        if (other.getBeneficiary() != null && !other.getBeneficiary().equals(this.getBeneficiary())) {
            return false;
        }
        if (other.getEntitlements() == null ^ this.getEntitlements() == null) {
            return false;
        }
        if (other.getEntitlements() != null && !other.getEntitlements().equals(this.getEntitlements())) {
            return false;
        }
        if (other.getConsumptionConfiguration() == null ^ this.getConsumptionConfiguration() == null) {
            return false;
        }
        if (other.getConsumptionConfiguration() != null && !other.getConsumptionConfiguration().equals(this.getConsumptionConfiguration())) {
            return false;
        }
        if (other.getLicenseMetadata() == null ^ this.getLicenseMetadata() == null) {
            return false;
        }
        if (other.getLicenseMetadata() != null && !other.getLicenseMetadata().equals(this.getLicenseMetadata())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getReceivedMetadata() == null ^ this.getReceivedMetadata() == null) {
            return false;
        }
        return other.getReceivedMetadata() == null || other.getReceivedMetadata().equals(this.getReceivedMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseArn() == null ? 0 : this.getLicenseArn().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseName() == null ? 0 : this.getLicenseName().hashCode());
        hashCode = 31 * hashCode + (this.getProductName() == null ? 0 : this.getProductName().hashCode());
        hashCode = 31 * hashCode + (this.getProductSKU() == null ? 0 : this.getProductSKU().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getHomeRegion() == null ? 0 : this.getHomeRegion().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getValidity() == null ? 0 : this.getValidity().hashCode());
        hashCode = 31 * hashCode + (this.getBeneficiary() == null ? 0 : this.getBeneficiary().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlements() == null ? 0 : this.getEntitlements().hashCode());
        hashCode = 31 * hashCode + (this.getConsumptionConfiguration() == null ? 0 : this.getConsumptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseMetadata() == null ? 0 : this.getLicenseMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReceivedMetadata() == null ? 0 : this.getReceivedMetadata().hashCode());
        return hashCode;
    }

    public GrantedLicense clone() {
        try {
            return (GrantedLicense)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantedLicenseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

