/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.licensemanager.AWSLicenseManager;
import com.amazonaws.services.licensemanager.AWSLicenseManagerClientBuilder;
import com.amazonaws.services.licensemanager.model.AWSLicenseManagerException;
import com.amazonaws.services.licensemanager.model.AccessDeniedException;
import com.amazonaws.services.licensemanager.model.AuthorizationException;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.CreateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.DeleteLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.FailedDependencyException;
import com.amazonaws.services.licensemanager.model.FilterLimitExceededException;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.GetLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.GetServiceSettingsResult;
import com.amazonaws.services.licensemanager.model.InvalidParameterValueException;
import com.amazonaws.services.licensemanager.model.InvalidResourceStateException;
import com.amazonaws.services.licensemanager.model.LicenseUsageException;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListAssociationsForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseConfigurationsResult;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryRequest;
import com.amazonaws.services.licensemanager.model.ListResourceInventoryResult;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceRequest;
import com.amazonaws.services.licensemanager.model.ListTagsForResourceResult;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.ListUsageForLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.RateLimitExceededException;
import com.amazonaws.services.licensemanager.model.ResourceLimitExceededException;
import com.amazonaws.services.licensemanager.model.ServerInternalException;
import com.amazonaws.services.licensemanager.model.TagResourceRequest;
import com.amazonaws.services.licensemanager.model.TagResourceResult;
import com.amazonaws.services.licensemanager.model.UntagResourceRequest;
import com.amazonaws.services.licensemanager.model.UntagResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseConfigurationResult;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import com.amazonaws.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResult;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsRequest;
import com.amazonaws.services.licensemanager.model.UpdateServiceSettingsResult;
import com.amazonaws.services.licensemanager.model.transform.CreateLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.CreateLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.DeleteLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.DeleteLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.GetLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.GetLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.GetServiceSettingsRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.GetServiceSettingsResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListAssociationsForLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListAssociationsForLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListLicenseConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListLicenseConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListLicenseSpecificationsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListLicenseSpecificationsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListResourceInventoryRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListResourceInventoryResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListUsageForLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.ListUsageForLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateLicenseConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateLicenseConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateLicenseSpecificationsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateLicenseSpecificationsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateServiceSettingsRequestProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.transform.UpdateServiceSettingsResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSLicenseManagerClient
extends AmazonWebServiceClient
implements AWSLicenseManager {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLicenseManager.class);
    private static final String DEFAULT_SIGNING_NAME = "license-manager";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FailedDependencyException").withModeledClass(FailedDependencyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AuthorizationException").withModeledClass(AuthorizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceStateException").withModeledClass(InvalidResourceStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RateLimitExceededException").withModeledClass(RateLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FilterLimitExceededException").withModeledClass(FilterLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerInternalException").withModeledClass(ServerInternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LicenseUsageException").withModeledClass(LicenseUsageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withModeledClass(ResourceLimitExceededException.class)).withBaseServiceExceptionClass(AWSLicenseManagerException.class));

    public static AWSLicenseManagerClientBuilder builder() {
        return AWSLicenseManagerClientBuilder.standard();
    }

    AWSLicenseManagerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSLicenseManagerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("license-manager.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/licensemanager/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/licensemanager/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateLicenseConfigurationResult createLicenseConfiguration(CreateLicenseConfigurationRequest request) {
        request = (CreateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLicenseConfigurationResult executeCreateLicenseConfiguration(CreateLicenseConfigurationRequest createLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLicenseConfigurationResult createLicenseConfigurationResult = (CreateLicenseConfigurationResult)response.getAwsResponse();
            return createLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLicenseConfigurationResult deleteLicenseConfiguration(DeleteLicenseConfigurationRequest request) {
        request = (DeleteLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLicenseConfigurationResult executeDeleteLicenseConfiguration(DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLicenseConfigurationResult deleteLicenseConfigurationResult = (DeleteLicenseConfigurationResult)response.getAwsResponse();
            return deleteLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLicenseConfigurationResult getLicenseConfiguration(GetLicenseConfigurationRequest request) {
        request = (GetLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLicenseConfigurationResult executeGetLicenseConfiguration(GetLicenseConfigurationRequest getLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLicenseConfigurationResult getLicenseConfigurationResult = (GetLicenseConfigurationResult)response.getAwsResponse();
            return getLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceSettingsResult getServiceSettings(GetServiceSettingsRequest request) {
        request = (GetServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetServiceSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceSettingsResult executeGetServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetServiceSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetServiceSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceSettingsResult getServiceSettingsResult = (GetServiceSettingsResult)response.getAwsResponse();
            return getServiceSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssociationsForLicenseConfigurationResult listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest request) {
        request = (ListAssociationsForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeListAssociationsForLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssociationsForLicenseConfigurationResult executeListAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociationsForLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociationsForLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociationsForLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((ListAssociationsForLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssociationsForLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssociationsForLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssociationsForLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociationsForLicenseConfigurationResult listAssociationsForLicenseConfigurationResult = (ListAssociationsForLicenseConfigurationResult)response.getAwsResponse();
            return listAssociationsForLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLicenseConfigurationsResult listLicenseConfigurations(ListLicenseConfigurationsRequest request) {
        request = (ListLicenseConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListLicenseConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLicenseConfigurationsResult executeListLicenseConfigurations(ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLicenseConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLicenseConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLicenseConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListLicenseConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLicenseConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLicenseConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLicenseConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLicenseConfigurationsResult listLicenseConfigurationsResult = (ListLicenseConfigurationsResult)response.getAwsResponse();
            return listLicenseConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLicenseSpecificationsForResourceResult listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest request) {
        request = (ListLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListLicenseSpecificationsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLicenseSpecificationsForResourceResult executeListLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLicenseSpecificationsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLicenseSpecificationsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLicenseSpecificationsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListLicenseSpecificationsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLicenseSpecificationsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLicenseSpecificationsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLicenseSpecificationsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLicenseSpecificationsForResourceResult listLicenseSpecificationsForResourceResult = (ListLicenseSpecificationsForResourceResult)response.getAwsResponse();
            return listLicenseSpecificationsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourceInventoryResult listResourceInventory(ListResourceInventoryRequest request) {
        request = (ListResourceInventoryRequest)this.beforeClientExecution(request);
        return this.executeListResourceInventory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourceInventoryResult executeListResourceInventory(ListResourceInventoryRequest listResourceInventoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourceInventoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourceInventoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourceInventoryRequestProtocolMarshaller(protocolFactory).marshall((ListResourceInventoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourceInventoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResourceInventory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourceInventoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourceInventoryResult listResourceInventoryResult = (ListResourceInventoryResult)response.getAwsResponse();
            return listResourceInventoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsageForLicenseConfigurationResult listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest request) {
        request = (ListUsageForLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeListUsageForLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsageForLicenseConfigurationResult executeListUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsageForLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsageForLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsageForLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((ListUsageForLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsageForLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsageForLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsageForLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsageForLicenseConfigurationResult listUsageForLicenseConfigurationResult = (ListUsageForLicenseConfigurationResult)response.getAwsResponse();
            return listUsageForLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLicenseConfigurationResult updateLicenseConfiguration(UpdateLicenseConfigurationRequest request) {
        request = (UpdateLicenseConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateLicenseConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLicenseConfigurationResult executeUpdateLicenseConfiguration(UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLicenseConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLicenseConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLicenseConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateLicenseConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLicenseConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLicenseConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLicenseConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLicenseConfigurationResult updateLicenseConfigurationResult = (UpdateLicenseConfigurationResult)response.getAwsResponse();
            return updateLicenseConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLicenseSpecificationsForResourceResult updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest request) {
        request = (UpdateLicenseSpecificationsForResourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateLicenseSpecificationsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLicenseSpecificationsForResourceResult executeUpdateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLicenseSpecificationsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLicenseSpecificationsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLicenseSpecificationsForResourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateLicenseSpecificationsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLicenseSpecificationsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLicenseSpecificationsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLicenseSpecificationsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLicenseSpecificationsForResourceResult updateLicenseSpecificationsForResourceResult = (UpdateLicenseSpecificationsForResourceResult)response.getAwsResponse();
            return updateLicenseSpecificationsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceSettingsResult updateServiceSettings(UpdateServiceSettingsRequest request) {
        request = (UpdateServiceSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateServiceSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceSettingsResult executeUpdateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateServiceSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"License Manager");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateServiceSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceSettingsResult updateServiceSettingsResult = (UpdateServiceSettingsResult)response.getAwsResponse();
            return updateServiceSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

