/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lexruntimev2.model.Interpretation;
import com.amazonaws.services.lexruntimev2.model.Message;
import com.amazonaws.services.lexruntimev2.model.SessionState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetSessionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String sessionId;
    private List<Message> messages;
    private List<Interpretation> interpretations;
    private SessionState sessionState;

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public GetSessionResult withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public GetSessionResult withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public GetSessionResult withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public List<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public void setInterpretations(Collection<Interpretation> interpretations) {
        if (interpretations == null) {
            this.interpretations = null;
            return;
        }
        this.interpretations = new ArrayList<Interpretation>(interpretations);
    }

    public GetSessionResult withInterpretations(Interpretation ... interpretations) {
        if (this.interpretations == null) {
            this.setInterpretations(new ArrayList<Interpretation>(interpretations.length));
        }
        for (Interpretation ele : interpretations) {
            this.interpretations.add(ele);
        }
        return this;
    }

    public GetSessionResult withInterpretations(Collection<Interpretation> interpretations) {
        this.setInterpretations(interpretations);
        return this;
    }

    public void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public GetSessionResult withSessionState(SessionState sessionState) {
        this.setSessionState(sessionState);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getInterpretations() != null) {
            sb.append("Interpretations: ").append(this.getInterpretations()).append(",");
        }
        if (this.getSessionState() != null) {
            sb.append("SessionState: ").append(this.getSessionState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResult)) {
            return false;
        }
        GetSessionResult other = (GetSessionResult)obj;
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getInterpretations() == null ^ this.getInterpretations() == null) {
            return false;
        }
        if (other.getInterpretations() != null && !other.getInterpretations().equals(this.getInterpretations())) {
            return false;
        }
        if (other.getSessionState() == null ^ this.getSessionState() == null) {
            return false;
        }
        return other.getSessionState() == null || other.getSessionState().equals(this.getSessionState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getInterpretations() == null ? 0 : this.getInterpretations().hashCode());
        hashCode = 31 * hashCode + (this.getSessionState() == null ? 0 : this.getSessionState().hashCode());
        return hashCode;
    }

    public GetSessionResult clone() {
        try {
            return (GetSessionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

