/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.ActiveContextTimeToLive;
import com.amazonaws.services.lexruntimev2.model.transform.ActiveContextMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ActiveContext
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private ActiveContextTimeToLive timeToLive;
    private Map<String, String> contextAttributes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ActiveContext withName(String name) {
        this.setName(name);
        return this;
    }

    public void setTimeToLive(ActiveContextTimeToLive timeToLive) {
        this.timeToLive = timeToLive;
    }

    public ActiveContextTimeToLive getTimeToLive() {
        return this.timeToLive;
    }

    public ActiveContext withTimeToLive(ActiveContextTimeToLive timeToLive) {
        this.setTimeToLive(timeToLive);
        return this;
    }

    public Map<String, String> getContextAttributes() {
        return this.contextAttributes;
    }

    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public ActiveContext withContextAttributes(Map<String, String> contextAttributes) {
        this.setContextAttributes(contextAttributes);
        return this;
    }

    public ActiveContext addContextAttributesEntry(String key, String value) {
        if (null == this.contextAttributes) {
            this.contextAttributes = new HashMap<String, String>();
        }
        if (this.contextAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.contextAttributes.put(key, value);
        return this;
    }

    public ActiveContext clearContextAttributesEntries() {
        this.contextAttributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTimeToLive() != null) {
            sb.append("TimeToLive: ").append(this.getTimeToLive()).append(",");
        }
        if (this.getContextAttributes() != null) {
            sb.append("ContextAttributes: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveContext)) {
            return false;
        }
        ActiveContext other = (ActiveContext)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTimeToLive() == null ^ this.getTimeToLive() == null) {
            return false;
        }
        if (other.getTimeToLive() != null && !other.getTimeToLive().equals(this.getTimeToLive())) {
            return false;
        }
        if (other.getContextAttributes() == null ^ this.getContextAttributes() == null) {
            return false;
        }
        return other.getContextAttributes() == null || other.getContextAttributes().equals(this.getContextAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeToLive() == null ? 0 : this.getTimeToLive().hashCode());
        hashCode = 31 * hashCode + (this.getContextAttributes() == null ? 0 : this.getContextAttributes().hashCode());
        return hashCode;
    }

    public ActiveContext clone() {
        try {
            return (ActiveContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActiveContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

